/*
 * Decompiled with CFR 0.152.
 */
package ciat.agrobio.hcluster;

import ciat.agrobio.core.GeneralTools;
import ciat.agrobio.core.JRITools_JavaUtils;
import ciat.agrobio.hcluster.Clade;
import ciat.agrobio.hcluster.PhylipWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class HierarchicalCluster {
    public static final String AVERAGE = "Average";
    public static final String COMPLETE = "Complete";
    public static final String SINGLE = "Single";
    public static final String[] LINKAGE_METHODS = new String[]{"Average", "Complete", "Single"};
    private double[][] distanceMatrix;
    private int linkageMethod;
    private String[] leafLabels;
    private int[] leafCount;
    private double[] joinDistance;
    private Clade[] nodes;
    private GeneralTools gTools = GeneralTools.getInstance();

    public HierarchicalCluster() {
        this(null, null, COMPLETE);
    }

    public HierarchicalCluster(double[][] distanceMatrix, String[] labels) {
        this(distanceMatrix, labels, COMPLETE);
    }

    public HierarchicalCluster(double[][] distanceMatrix, String[] labels, String linkageMethod) {
        this.setDistanceMatrix(distanceMatrix);
        this.setLeafLabels(labels);
        this.setLinkageMethod(linkageMethod);
    }

    public Clade cluster() {
        this.init();
        int rootIndex = -1;
        int i = 0;
        while (i < this.distanceMatrix.length - 1) {
            rootIndex = this.iterate();
            ++i;
        }
        Clade root = this.nodes[rootIndex];
        this.restore(this.distanceMatrix);
        return root;
    }

    public void similarityToDistance() {
        int i = 0;
        while (i < this.distanceMatrix.length) {
            int j = 0;
            while (j < this.distanceMatrix[0].length) {
                this.distanceMatrix[i][j] = 1.0 - this.distanceMatrix[i][j];
                ++j;
            }
            ++i;
        }
    }

    private void init() {
        this.leafCount = new int[this.distanceMatrix.length];
        this.joinDistance = new double[this.distanceMatrix.length];
        this.nodes = new Clade[this.distanceMatrix.length];
        int i = 0;
        while (i < this.distanceMatrix.length) {
            this.joinDistance[i] = 0.0;
            this.leafCount[i] = 1;
            this.nodes[i] = new Clade(this.leafLabels[i], 0.0);
            ++i;
        }
    }

    private double newDistance(int oneJoin, int twoJoin, int fixrow) {
        double newD = -1111.0;
        switch (this.linkageMethod) {
            case 0: {
                int oneN = this.leafCount[oneJoin];
                int twoN = this.leafCount[twoJoin];
                newD = (this.distanceMatrix[Math.max(oneJoin, fixrow)][Math.min(oneJoin, fixrow)] * (double)oneN + this.distanceMatrix[Math.max(twoJoin, fixrow)][Math.min(twoJoin, fixrow)] * (double)twoN) / (double)(oneN + twoN);
                break;
            }
            case 1: {
                newD = Math.max(this.distanceMatrix[Math.max(oneJoin, fixrow)][Math.min(oneJoin, fixrow)], this.distanceMatrix[Math.max(twoJoin, fixrow)][Math.min(twoJoin, fixrow)]);
                break;
            }
            case 2: {
                newD = Math.min(this.distanceMatrix[Math.max(oneJoin, fixrow)][Math.min(oneJoin, fixrow)], this.distanceMatrix[Math.max(twoJoin, fixrow)][Math.min(twoJoin, fixrow)]);
            }
        }
        return newD;
    }

    private int iterate() {
        double newDistance = Double.MIN_VALUE;
        int two = -1;
        int one = -1;
        double currentCloseness = Double.MAX_VALUE;
        int i = 1;
        while (i < this.distanceMatrix.length) {
            int j = 0;
            while (j < i) {
                if (this.distanceMatrix[i][j] >= 0.0 && this.distanceMatrix[i][j] < currentCloseness) {
                    currentCloseness = this.distanceMatrix[i][j];
                    one = i;
                    two = j;
                }
                ++j;
            }
            ++i;
        }
        if (this.leafCount[one] > this.leafCount[two]) {
            i = two;
            two = one;
            one = i;
        }
        i = 0;
        while (i < this.distanceMatrix.length) {
            if (one != i && two != i) {
                this.distanceMatrix[Math.max((int)two, (int)i)][Math.min((int)two, (int)i)] = newDistance = this.newDistance(one, two, i);
            }
            ++i;
        }
        i = 0;
        while (i < this.distanceMatrix.length) {
            if (i != one) {
                this.distanceMatrix[Math.max((int)one, (int)i)][Math.min((int)one, (int)i)] = -9999.0;
            }
            ++i;
        }
        this.nodes[one].setBranchLength(currentCloseness - this.joinDistance[one]);
        this.nodes[two].setBranchLength(currentCloseness - this.joinDistance[two]);
        Clade joinedNode = new Clade();
        joinedNode.add(this.nodes[two]);
        joinedNode.add(this.nodes[one]);
        this.nodes[two] = joinedNode;
        this.nodes[one] = null;
        this.mergeMembers(this.leafCount, two, one);
        this.joinDistance[two] = currentCloseness;
        return two;
    }

    private void mergeMembers(int[] numMember, int joinedNodeIndex, int oldNodeIndex) {
        int n = joinedNodeIndex;
        numMember[n] = numMember[n] + numMember[oldNodeIndex];
    }

    private void restore(double[][] distanceMatrix) {
        int i = 1;
        while (i < distanceMatrix.length) {
            int j = 0;
            while (j < i) {
                distanceMatrix[i][j] = distanceMatrix[j][i];
                ++j;
            }
            ++i;
        }
    }

    public double[][] getDistanceMatrix() {
        return this.distanceMatrix;
    }

    public double[][] getReorderedMatrix(Clade root) {
        return this.getReorderedMatrix(this.getReorderedLabels(root));
    }

    public double[][] getReorderedMatrix(String[] reorderedLabels) {
        int[] indexes = new int[this.leafLabels.length];
        int i = 0;
        while (i < reorderedLabels.length) {
            int j = 0;
            while (j < reorderedLabels.length) {
                if (reorderedLabels[i] == this.leafLabels[j]) {
                    indexes[i] = j;
                    break;
                }
                ++j;
            }
            ++i;
        }
        double[][] d = new double[this.distanceMatrix.length][this.distanceMatrix.length];
        int i2 = 0;
        while (i2 < d.length) {
            int j = 0;
            while (j < d.length) {
                d[i2][j] = this.distanceMatrix[indexes[i2]][indexes[j]];
                ++j;
            }
            ++i2;
        }
        return d;
    }

    public String[] getReorderedLabels(Clade root) {
        String[] labels = new String[this.leafLabels.length];
        int k = 0;
        Enumeration<TreeNode> e = root.depthFirstEnumeration();
        while (e.hasMoreElements()) {
            Clade node = (Clade)e.nextElement();
            if (!node.isLeaf() || node.getUserObject() == null) continue;
            labels[k++] = node.toString();
        }
        return labels;
    }

    public void setDistanceMatrix(double[][] distanceMatrix) {
        if (distanceMatrix != null && distanceMatrix.length != distanceMatrix[0].length) {
            throw new IllegalArgumentException("Distance matrix must be square");
        }
        this.distanceMatrix = distanceMatrix;
    }

    public String[] getLeafLabels() {
        return this.leafLabels;
    }

    public void setLeafLabels(String[] labels) {
        this.leafLabels = labels;
    }

    public String getLinkageMethod() {
        return LINKAGE_METHODS[this.linkageMethod];
    }

    public void setLinkageMethod(String linkageMethod) {
        this.linkageMethod = -1;
        int i = 0;
        while (i < LINKAGE_METHODS.length) {
            if (LINKAGE_METHODS[i].equals(linkageMethod)) {
                this.linkageMethod = i;
                return;
            }
            ++i;
        }
        if (this.linkageMethod == -1) {
            throw new IllegalArgumentException("Invalid linkage method: " + linkageMethod);
        }
    }

    public TreeMap<Integer, TreeSet<String>> hclusteringClusters(String[] sampleNames, double[][] distances, Integer minClusterSize, Double cutHeight, boolean extra) {
        try {
            String treeString = this.hclusteringTree(sampleNames, distances);
            String[] labelsReordered = this.gTools.reorderLabels(sampleNames, treeString);
            double[][] distancesReordered = this.gTools.reorderDistances(distances, sampleNames, labelsReordered);
            System.err.println("preJRI");
            JRITools_JavaUtils jritools = JRITools_JavaUtils.getInstance(null);
            System.err.println("precut");
            TreeMap<Integer, TreeSet<String>> clusters = jritools.dynamicTreeCut(treeString, distancesReordered, labelsReordered, minClusterSize, cutHeight, extra);
            System.err.println("afterCut");
            jritools.shutdown();
            System.err.println(String.valueOf(GeneralTools.time()) + " Clusters=" + clusters.size() + "\n");
            for (Map.Entry<Integer, TreeSet<String>> entry : clusters.entrySet()) {
                int clusterId = entry.getKey();
                TreeSet<String> cluster = entry.getValue();
                for (String name : cluster) {
                    System.err.println(String.valueOf(name) + "\t" + clusterId + "\t" + cluster.size());
                }
            }
            System.err.println("\n\n");
            return clusters;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String[] hclusteringClustersNoJRI(TreeMap<Integer, TreeSet<String>> clusters) {
        try {
            ArrayList<String> al = new ArrayList<String>();
            System.out.println(String.valueOf(GeneralTools.time()) + " Clusters=" + clusters.size() + "\n");
            for (Map.Entry<Integer, TreeSet<String>> entry : clusters.entrySet()) {
                StringBuilder sb = new StringBuilder();
                int clusterId = entry.getKey();
                sb.append(clusterId);
                TreeSet<String> cluster = entry.getValue();
                sb.append(" " + cluster.size());
                for (String name : cluster) {
                    System.out.println(String.valueOf(name) + "\t" + clusterId + "\t" + cluster.size());
                    sb.append(" " + name);
                }
                al.add(sb.toString());
            }
            System.out.println("\n\n");
            String[] ret = new String[al.size()];
            ret = al.toArray(ret);
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public TreeMap<Integer, TreeSet<String>> findClusters(double[] result, String[] labels) {
        try {
            TreeMap<Integer, TreeSet<String>> clusters = new TreeMap<Integer, TreeSet<String>>();
            int i = 0;
            while (i < result.length) {
                int clusterId = (int)result[i];
                TreeSet<String> cluster = clusters.get(clusterId);
                if (cluster == null) {
                    cluster = new TreeSet();
                    clusters.put(clusterId, cluster);
                }
                String label = labels[i];
                cluster.add(label);
                ++i;
            }
            return clusters;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public TreeMap<Integer, TreeSet<String>> findClusters(int[] result, String[] labels) {
        return this.findClusters(Arrays.stream(result).asDoubleStream().toArray(), labels);
    }

    public String hclusteringTree(String[] sampleNames, double[][] distances) {
        try {
            System.err.println(String.valueOf(GeneralTools.time()) + " Distances=" + distances.length + "x" + distances[0].length);
            String method = COMPLETE;
            this.setDistanceMatrix(distances);
            this.setLeafLabels(sampleNames);
            this.setLinkageMethod(method);
            System.err.println("hierarchical method=" + method);
            Clade root = this.cluster();
            PhylipWriter writer = new PhylipWriter();
            StringWriter sw = new StringWriter();
            writer.setOutput(sw);
            try {
                writer.write(new DefaultTreeModel(root));
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            String treeString = sw.toString().replace("\n", "");
            return treeString;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

