/*
 * Decompiled with CFR 0.152.
 */
package ciat.agrobio.core;

import ciat.agrobio.core.Variant;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;

public class VariantManager {
    private int numVariants;
    private int numSamples;
    private byte ploidy = 0;
    private byte[][] sampleXvariantP1 = null;
    private byte[][] sampleXvariantP2 = null;
    private boolean cleanVariantData = true;
    private ConcurrentLinkedDeque<Variant> variantsRaw = new ConcurrentLinkedDeque();
    private ConcurrentLinkedQueue<Variant> variantsQueue = new ConcurrentLinkedQueue();

    public byte[][] getSampleXvariantP1() {
        return this.sampleXvariantP1;
    }

    public byte[][] getSampleXvariantP2() {
        return this.sampleXvariantP2;
    }

    public void setNumSamples(int numSamples) {
        this.numSamples = numSamples;
    }

    public final int getNumSamples() {
        return this.numSamples;
    }

    public void setNumVariants(int numVariants) {
        this.numVariants = numVariants;
    }

    public final int getNumVariants() {
        return this.numVariants;
    }

    public void setPloidy(byte ploidy) {
        this.ploidy = ploidy;
    }

    public byte getPloidy() {
        return this.ploidy;
    }

    private void clear() {
        if (this.variantsRaw != null) {
            this.variantsRaw.clear();
        }
        this.variantsRaw = new ConcurrentLinkedDeque();
        if (this.variantsQueue != null) {
            this.variantsQueue.clear();
        }
        this.variantsQueue = new ConcurrentLinkedQueue();
    }

    public void setCleanVariantData(boolean cleanVariantData) {
        this.cleanVariantData = cleanVariantData;
    }

    public boolean isCleanVariantData() {
        return this.cleanVariantData;
    }

    public void populateSampleVariant() {
        Variant variant;
        this.sampleXvariantP1 = new byte[this.numSamples][this.numVariants];
        this.sampleXvariantP2 = new byte[this.numSamples][this.numVariants];
        while ((variant = this.variantsQueue.poll()) != null) {
            for (int i = 0; i < this.numSamples; ++i) {
                this.sampleXvariantP1[i][variant.getVariantId() - 1] = variant.getDataSamplesP1()[i];
                this.sampleXvariantP2[i][variant.getVariantId() - 1] = variant.getDataSamplesP2()[i];
            }
            variant.cleanDataSamples();
        }
    }

    public boolean hasMoreRaw() {
        return !this.variantsRaw.isEmpty();
    }

    public boolean putVariantRaw(Variant variant) {
        try {
            long free = Runtime.getRuntime().freeMemory();
            if (free < 0x3000000L) {
                return false;
            }
            this.variantsRaw.offer(variant);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Variant getNextVariantRaw() {
        return this.variantsRaw.poll();
    }

    public void putVariantQueue(Variant variant) {
        this.variantsQueue.offer(variant);
    }
}

