/*
 * Decompiled with CFR 0.152.
 */
package ciat.agrobio.core;

import java.util.Arrays;
import java.util.Comparator;

public class Variant
implements Comparable<Variant> {
    private int variantId;
    private byte numAlleles;
    private byte[][] dataRaw;
    private byte[] dataSamplesP1;
    private byte[] dataSamplesP2;
    private static AlphanumericComparator alnumComparator = new AlphanumericComparator();

    public Variant(int variantId, byte[][] dataRaw) {
        this.variantId = variantId;
        this.dataRaw = dataRaw;
    }

    public int getVariantId() {
        return this.variantId;
    }

    public String getVariantVCFId() {
        return new String(this.dataRaw[2]);
    }

    public byte[][] getDataRaw() {
        return this.dataRaw;
    }

    public String getVariantName() {
        return String.valueOf(new String(this.dataRaw[0])) + "\t|\t" + new String(this.dataRaw[1]) + "\t|\t" + new String(this.dataRaw[3]) + "\t|\t" + new String(this.dataRaw[4]);
    }

    public String getInfo() {
        return new String(this.dataRaw[7]);
    }

    public String getFormat() {
        return new String(this.dataRaw[8]);
    }

    public void cleanDataRaw() {
        this.dataRaw = (byte[][])Arrays.copyOf(this.dataRaw, 9);
    }

    public void cleanDataSamples() {
        this.dataSamplesP1 = null;
        this.dataSamplesP2 = null;
    }

    public void setNumAlleles(byte numAlleles) {
        this.numAlleles = numAlleles;
    }

    public byte getNumAlleles() {
        return this.numAlleles;
    }

    public byte[] getDataSamplesP1() {
        return this.dataSamplesP1;
    }

    public void setDataSamplesP1(byte[] dataSamplesP1) {
        this.dataSamplesP1 = dataSamplesP1;
    }

    public byte[] getDataSamplesP2() {
        return this.dataSamplesP2;
    }

    public void setDataSamplesP2(byte[] dataSamplesP2) {
        this.dataSamplesP2 = dataSamplesP2;
    }

    public String toString() {
        return String.valueOf(this.variantId) + "\t" + this.getVariantName();
    }

    public String toVariantString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.dataRaw[0]);
        int i = 1;
        while (i < this.dataRaw.length) {
            sb.append("\t" + new String(this.dataRaw[i]));
            ++i;
        }
        return sb.toString();
    }

    @Override
    public int compareTo(Variant other) {
        String chr1 = this.getVariantName().split("\t\\|\t")[0];
        String chr2 = other.getVariantName().split("\t\\|\t")[0];
        Integer pos1 = Integer.valueOf(this.getVariantName().split("\t\\|\t")[1]);
        Integer pos2 = Integer.valueOf(other.getVariantName().split("\t\\|\t")[1]);
        String ref1 = this.getVariantName().split("\t\\|\t")[2];
        String ref2 = other.getVariantName().split("\t\\|\t")[2];
        String alt1 = this.getVariantName().split("\t\\|\t")[3];
        String alt2 = other.getVariantName().split("\t\\|\t")[3];
        int cComp = alnumComparator.compare(chr1, chr2);
        int pComp = pos1.compareTo(pos2);
        int rComp = ref1.compareTo(ref2);
        int aComp = alt1.compareTo(alt2);
        if (cComp != 0) {
            return cComp;
        }
        if (pComp != 0) {
            return pComp;
        }
        if (rComp != 0) {
            return rComp;
        }
        return aComp;
    }

    static class AlphanumericComparator
    implements Comparator<String> {
        AlphanumericComparator() {
        }

        @Override
        public int compare(String firstString, String secondString) {
            if (secondString == null || firstString == null) {
                return 0;
            }
            int lengthFirstStr = firstString.length();
            int lengthSecondStr = secondString.length();
            int index1 = 0;
            int index2 = 0;
            while (index1 < lengthFirstStr && index2 < lengthSecondStr) {
                int result;
                char ch1 = firstString.charAt(index1);
                char ch2 = secondString.charAt(index2);
                char[] space1 = new char[lengthFirstStr];
                char[] space2 = new char[lengthSecondStr];
                int loc1 = 0;
                int loc2 = 0;
                do {
                    space1[loc1++] = ch1;
                } while (++index1 < lengthFirstStr && Character.isDigit(ch1 = firstString.charAt(index1)) == Character.isDigit(space1[0]));
                do {
                    space2[loc2++] = ch2;
                } while (++index2 < lengthSecondStr && Character.isDigit(ch2 = secondString.charAt(index2)) == Character.isDigit(space2[0]));
                String str1 = new String(space1);
                String str2 = new String(space2);
                if (Character.isDigit(space1[0]) && Character.isDigit(space2[0])) {
                    Integer firstNumberToCompare = Integer.parseInt(str1.trim());
                    Integer secondNumberToCompare = Integer.parseInt(str2.trim());
                    result = firstNumberToCompare.compareTo(secondNumberToCompare);
                } else {
                    result = str1.compareTo(str2);
                }
                if (result == 0) continue;
                return result;
            }
            return lengthFirstStr - lengthSecondStr;
        }
    }
}

