/*
 * Decompiled with CFR 0.152.
 */
package ciat.agrobio.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.SecureRandom;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class GeneralTools {
    public static final DateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    public static final DecimalFormat decimalFormat = new DecimalFormat("#.############", new DecimalFormatSymbols(Locale.US));
    private static SecureRandom prng;
    private static GeneralTools instance;

    static {
        try {
            prng = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        instance = new GeneralTools();
    }

    private GeneralTools() {
    }

    public static GeneralTools getInstance() {
        return instance;
    }

    public int getRandomInteger() {
        return prng.nextInt();
    }

    public static String time() {
        Calendar cal = Calendar.getInstance();
        return dateFormat.format(cal.getTime());
    }

    public String RAMInfo(Runtime runtime) {
        double gb = 1.073741824E9;
        NumberFormat format = NumberFormat.getInstance();
        StringBuilder sb = new StringBuilder();
        sb.append("\n##### Heap utilization statistics [GB] #####\n");
        sb.append("Max Memory=" + format.format((double)runtime.maxMemory() / gb) + "\n");
        sb.append("Current Total Memory=" + format.format((double)runtime.totalMemory() / gb) + "\n");
        sb.append("Current Used Memory=" + format.format((double)(runtime.totalMemory() - runtime.freeMemory()) / gb) + "\n");
        sb.append("Current Free Memory=" + format.format((double)runtime.freeMemory() / gb) + "\n");
        sb.append("############################################\n");
        return sb.toString();
    }

    public final byte[][] concatSeqQual(ArrayList<byte[]> arrays) {
        byte[] all = this.concat(arrays);
        int size = all.length;
        int sizeSeq = 0;
        int sizeQual = 0;
        byte[] byArray = all;
        int n = all.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            if ('+' == (char)(b & 0xFF)) {
                sizeQual = size - sizeSeq - 1;
                break;
            }
            ++sizeSeq;
            ++n2;
        }
        byte[][] ret = new byte[2][];
        if (sizeSeq > 0) {
            byte[] destSeq = new byte[sizeSeq];
            System.arraycopy(all, 0, destSeq, 0, sizeSeq);
            ret[0] = destSeq;
        }
        if (sizeQual > 0) {
            byte[] destQual = new byte[sizeQual];
            System.arraycopy(all, sizeSeq + 1, destQual, 0, sizeQual);
            ret[1] = destQual;
        }
        return ret;
    }

    public final byte[] concat(ArrayList<byte[]> arrays) {
        int size = 0;
        for (byte[] a : arrays) {
            size += a.length;
        }
        byte[] dest = new byte[size];
        int destPos = 0;
        int i = 0;
        while (i < arrays.size()) {
            if (i > 0) {
                destPos += arrays.get(i - 1).length;
            }
            int length = arrays.get(i).length;
            System.arraycopy(arrays.get(i), 0, dest, destPos, length);
            ++i;
        }
        return dest;
    }

    public int round(double d) {
        int i;
        double dAbs = Math.abs(d);
        double result = dAbs - (double)(i = (int)dAbs);
        if (result < 0.5) {
            return d < 0.0 ? -i : i;
        }
        return d < 0.0 ? -(i + 1) : i + 1;
    }

    public char[] bytesToStringUTFCustom(byte[] bytes) {
        char[] buffer = new char[bytes.length >> 1];
        int i = 0;
        while (i < buffer.length) {
            char c;
            int bpos = i << 1;
            buffer[i] = c = (char)(((bytes[bpos] & 0xFF) << 8) + (bytes[bpos + 1] & 0xFF));
            ++i;
        }
        return buffer;
    }

    public byte[] stringToBytesUTFCustom(char[] str) {
        byte[] b = new byte[str.length << 1];
        int i = 0;
        while (i < str.length) {
            char strChar = str[i];
            int bpos = i << 1;
            b[bpos] = (byte)((strChar & 0xFF00) >> 8);
            b[bpos + 1] = (byte)(strChar & 0xFF);
            ++i;
        }
        return b;
    }

    public List<String> directoriesToFiles(List<String> inputFastaFileNames) {
        ArrayList<String> outputFastaFileNames = new ArrayList<String>();
        try {
            for (String s : inputFastaFileNames) {
                File f = new File(s);
                if (!f.isDirectory()) {
                    outputFastaFileNames.add(f.getCanonicalPath());
                    continue;
                }
                File[] fileArray = f.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File ff = fileArray[n2];
                    outputFastaFileNames.add(ff.getCanonicalPath());
                    ++n2;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return outputFastaFileNames;
    }

    public <K, V extends Comparable<? super V>> Map<K, V> sortByValue(Map<K, V> map) {
        LinkedList<Map.Entry<K, V>> list = new LinkedList<Map.Entry<K, V>>(map.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> o1, Map.Entry<K, V> o2) {
                int compare = ((Comparable)o1.getValue()).compareTo(o2.getValue());
                if (compare == 0) {
                    Long key1 = (Long)o1.getKey();
                    Long key2 = (Long)o2.getKey();
                    return 1 * key1.compareTo(key2);
                }
                return -1 * compare;
            }
        });
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : list) {
            result.put(entry.getKey(), (Comparable)entry.getValue());
        }
        return result;
    }

    public ArrayList<String> generateKmerVocabulary(int k) {
        ArrayList<String> vocabulary = new ArrayList<String>();
        char[] chars = "ATCG".toCharArray();
        int len = k;
        this.iterate(chars, len, new char[len], 0, vocabulary);
        return vocabulary;
    }

    private void iterate(char[] chars, int len, char[] build, int pos, ArrayList<String> vocabulary) {
        if (pos == len) {
            String word = new String(build);
            vocabulary.add(word);
            return;
        }
        int i = 0;
        while (i < chars.length) {
            build[pos] = chars[i];
            this.iterate(chars, len, build, pos + 1, vocabulary);
            ++i;
        }
    }

    public final String reverseComplement(String sequence) {
        StringBuilder sb = new StringBuilder();
        int i = sequence.length() - 1;
        while (i >= 0) {
            switch (sequence.charAt(i)) {
                case 'A': 
                case 'a': {
                    sb.append("T");
                    break;
                }
                case 'T': 
                case 't': {
                    sb.append("A");
                    break;
                }
                case 'C': 
                case 'c': {
                    sb.append("G");
                    break;
                }
                case 'G': 
                case 'g': {
                    sb.append("C");
                    break;
                }
            }
            --i;
        }
        return sb.toString();
    }

    public long classBuildTimeMillis(Class c) {
        URL resource = c.getResource(String.valueOf(c.getSimpleName()) + ".class");
        if (resource == null) {
            System.out.println("Failed to find class file for class: " + c.getName());
            return 0L;
        }
        if (resource.getProtocol().equals("file")) {
            try {
                return new File(resource.toURI()).lastModified();
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
                return 0L;
            }
        }
        if (resource.getProtocol().equals("jar")) {
            String path = resource.getPath();
            return new File(path.substring(5, path.indexOf("!"))).lastModified();
        }
        System.out.println("Unhandled url protocol: " + resource.getProtocol() + " for class: " + c.getName() + " resource: " + resource.toString());
        return 0L;
    }

    public <T extends Comparable<? super T>> List<T> asSortedList(Collection<T> c) {
        ArrayList<T> list = new ArrayList<T>(c);
        Collections.sort(list);
        return list;
    }

    public String[] reorderLabels(String[] original, String treeString) {
        String[] labelsReordered = new String[original.length];
        String[] data = treeString.split(",");
        int i = 0;
        while (i < data.length) {
            String label = data[i].trim();
            if (label.contains("(")) {
                label = label.substring(label.lastIndexOf("(") + 1);
            }
            if (label.contains(")")) {
                label = label.substring(0, label.indexOf(")"));
            }
            if (label.contains(":")) {
                label = label.substring(0, label.indexOf(":"));
            }
            labelsReordered[i] = label;
            ++i;
        }
        return labelsReordered;
    }

    public double[][] reorderDistances(double[][] distancesOriginal, String[] labelsOriginal, String[] labelsReordered) {
        int size = distancesOriginal.length;
        double[][] distancesReordered = new double[size][size];
        int[] indexToReorder = new int[size];
        int i = 0;
        while (i < size) {
            String labelOriginal = labelsOriginal[i].trim();
            int j = 0;
            while (j < size) {
                String labelReordered = labelsReordered[j].trim();
                if (labelOriginal.equalsIgnoreCase(labelReordered)) {
                    indexToReorder[i] = j;
                    break;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < size) {
            int j = 0;
            while (j < size) {
                distancesReordered[indexToReorder[i]][indexToReorder[j]] = distancesOriginal[i][j];
                ++j;
            }
            ++i;
        }
        return distancesReordered;
    }

    public Object[] readDistancesSamples(String input) {
        try {
            BufferedReader br = new BufferedReader(new FileReader(input));
            String line = br.readLine();
            System.err.println(line);
            int numOfSamples = Integer.parseInt(line.split("[\\s,\\t]+")[0]);
            double[][] distances = new double[numOfSamples][numOfSamples];
            String[] sampleNames = new String[numOfSamples];
            int i = 0;
            while ((line = br.readLine()) != null) {
                String[] data = line.split("[\\s,\\t]+");
                sampleNames[i] = data[0].trim();
                int j = 0;
                while (j < numOfSamples) {
                    try {
                        distances[i][j] = Double.parseDouble(data[j + 1]);
                    }
                    catch (NumberFormatException e) {
                        distances[i][j] = 1.0;
                    }
                    ++j;
                }
                ++i;
            }
            br.close();
            Object[] ret = new Object[]{distances, sampleNames};
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

