/*
 * Decompiled with CFR 0.152.
 */
package ciat.agrobio.core;

import ciat.agrobio.core.CalculateDistancesChildTask;
import ciat.agrobio.core.CalculateDistancesTask;
import ciat.agrobio.core.VariantManager;
import ciat.agrobio.io.VCFManager;
import java.util.List;
import java.util.concurrent.ForkJoinPool;

public class CalculateDistancesCOSINE {
    public static void resetCounters() {
        CalculateDistancesChildTask.resetCounters();
    }

    public double[][] calculateDistances(int numOfThreads, List<String> sampleNames, VariantManager vm, VCFManager vcfm, boolean ignoreHets, boolean onlyHets, boolean ignoremissing) {
        try {
            int numOfSamples = sampleNames.size();
            double[][] distances = new double[numOfSamples][numOfSamples];
            CalculateDistancesTask task = new CalculateDistancesTask(sampleNames, vm, vcfm, ignoreHets, onlyHets, ignoremissing, distances);
            ForkJoinPool pool = new ForkJoinPool(numOfThreads);
            pool.execute(task);
            return (double[][])task.get();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

