/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.test;

import edu.rit.pj.Comm;
import edu.rit.pj.WorkerLongForLoop;
import edu.rit.pj.WorkerLongStrideForLoop;
import edu.rit.pj.WorkerRegion;
import edu.rit.pj.WorkerTeam;

public class Test22 {
    private Test22() {
    }

    public static void main(String[] stringArray) throws Throwable {
        Comm.init(stringArray);
        if (stringArray.length != 3) {
            Test22.usage();
        }
        final long l = Long.parseLong(stringArray[0]);
        final long l2 = Long.parseLong(stringArray[1]);
        final long l3 = Long.parseLong(stringArray[2]);
        new WorkerTeam().execute(new WorkerRegion(){

            public void run() throws Exception {
                final int n = this.getThreadIndex();
                System.out.printf("Begin thread %d%n", n);
                if (l3 == 1L) {
                    this.execute(l, l2, new WorkerLongForLoop(){

                        public void run(long l, long l2) {
                            for (long i = l; i <= l2; ++i) {
                                System.out.printf("i = %d, thread = %d%n", i, n);
                            }
                        }
                    });
                } else {
                    this.execute(l, l2, l3, new WorkerLongStrideForLoop(){

                        public void run(long l, long l2, long l3) {
                            for (long i = l; i <= l2; i += l3) {
                                System.out.printf("i = %d, thread = %d%n", i, n);
                            }
                        }
                    });
                }
                System.out.printf("End thread %d%n", n);
            }
        });
    }

    private static void usage() {
        System.err.println("Usage: java [-Dpj.np=<K>] [-Dpj.schedule=<schedule>] edu.rit.pj.test.Test22 <lb> <ub> <stride>");
        System.err.println("<K> = Number of parallel processes");
        System.err.println("<schedule> = Worker for loop schedule");
        System.err.println("<lb> = Loop index lower bound, inclusive");
        System.err.println("<ub> = Loop index upper bound, inclusive");
        System.err.println("<stride> = Loop stride");
        System.exit(1);
    }
}

