## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(
    collapse = TRUE,
    comment = "#>",
    crop = NULL,
    dpi = 100
)

## ----installation, eval=FALSE-------------------------------------------------
#  if(!requireNamespace('BiocManager', quietly = TRUE))
#    install.packages('BiocManager')
#  BiocManager::install("cogeqc")

## ----load_package, message=FALSE----------------------------------------------
# Load package after installation
library(cogeqc)

## ----run_busco, eval=FALSE----------------------------------------------------
#  # Path to FASTA file
#  sequence <- system.file("extdata", "Hse_subset.fa", package = "cogeqc")
#  
#  # Path to directory where BUSCO datasets will be stored
#  download_path <- paste0(tempdir(), "/datasets")
#  
#  # Run BUSCO if it is installed
#  if(busco_is_installed()) {
#    run_busco(sequence, outlabel = "Hse", mode = "genome",
#              lineage = "burkholderiales_odb10",
#              outpath = tempdir(), download_path = download_path)
#  }

## -----------------------------------------------------------------------------
# Path to output directory
output_dir <- system.file("extdata", package = "cogeqc")

busco_summary <- read_busco(output_dir)
busco_summary

## -----------------------------------------------------------------------------
data(batch_summary)
batch_summary

## ----plot_busco, out.width = '100%'-------------------------------------------
# Single FASTA file - Ostreococcus tauri
plot_busco(busco_summary)

# Batch mode - Herbaspirillum seropedicae and H. rubrisubalbicans
plot_busco(batch_summary)

## -----------------------------------------------------------------------------
sessionInfo()

