## ---- eval=FALSE--------------------------------------------------------------
#  if (!requireNamespace("BiocManager", quietly=TRUE))
#      install.packages("BiocManager")
#  BiocManager::install('biodbNci')

## ---- results='hide'----------------------------------------------------------
mybiodb <- biodb::newInst()

## -----------------------------------------------------------------------------
conn <- mybiodb$getFactory()$createConn('nci.cactus')

## -----------------------------------------------------------------------------
dbExtract <- system.file("extdata", 'generated', "cactus_extract.txt.gz",
    package="biodbNci")
conn$setPropValSlot('urls', 'db.gz.url', dbExtract)

## -----------------------------------------------------------------------------
ids <- conn$getEntryIds(2)
ids

## -----------------------------------------------------------------------------
entries <- conn$getEntry(ids)
entries

## -----------------------------------------------------------------------------
x <- mybiodb$entriesToDataframe(entries)
x

## -----------------------------------------------------------------------------
conn$wsChemicalIdentifierResolver(structid='C=O', repr='InChI')

## -----------------------------------------------------------------------------
conn$convCasToInchi('87605-72-9')
conn$convCasToInchikey('87605-72-9')

## -----------------------------------------------------------------------------
mybiodb$terminate()

## -----------------------------------------------------------------------------
sessionInfo()

