## ---- eval=FALSE--------------------------------------------------------------
#  if (!requireNamespace("BiocManager", quietly=TRUE))
#      install.packages("BiocManager")
#  BiocManager::install('biodbNcbi')

## ---- results='hide'----------------------------------------------------------
mybiodb <- biodb::newInst()

## -----------------------------------------------------------------------------
gene <- mybiodb$getFactory()$createConn('ncbi.gene')

## -----------------------------------------------------------------------------
ccds <- mybiodb$getFactory()$createConn('ncbi.ccds')
pubchem.comp <- mybiodb$getFactory()$createConn('ncbi.pubchem.comp')
pubchem.subst <- mybiodb$getFactory()$createConn('ncbi.pubchem.subst')

## -----------------------------------------------------------------------------
gene$getNbEntries()

## -----------------------------------------------------------------------------
ids <- gene$getEntryIds(2)
ids

## -----------------------------------------------------------------------------
entries <- gene$getEntry(ids)
entries

## -----------------------------------------------------------------------------
x <- mybiodb$entriesToDataframe(entries)
x

## -----------------------------------------------------------------------------
entryxml <- gene$wsEfetch('2833', retmode='xml', retfmt='parsed')
XML::getNodeSet(entryxml, "//Entrezgene_prot")

## -----------------------------------------------------------------------------
gene$wsEsearch(term='"chemokine"[Gene Name]', retmax=10, retfmt='ids')

## -----------------------------------------------------------------------------
gene$searchForEntries(fields=list(name='chemokine'), max.results=10)

## -----------------------------------------------------------------------------
infoxml <- pubchem.comp$wsEinfo(retfmt='parsed')
XML::getNodeSet(infoxml, "//Field[1]")

## -----------------------------------------------------------------------------
mybiodb$terminate()

## -----------------------------------------------------------------------------
sessionInfo()

