/*
 * Decompiled with CFR 0.152.
 */
package test;

import base.Sequence;
import java.util.Arrays;
import java.util.Map;

public class SequenceTest {
    public static void main(String[] stringArray) {
        SequenceTest.test_reversed();
    }

    public static void test4() {
        Object[] objectArray = new Sequence[]{new Sequence("TC"), new Sequence("AA"), new Sequence("GG"), new Sequence("GC"), new Sequence("CG"), new Sequence("CC"), new Sequence("CT"), new Sequence("TA"), new Sequence("TT"), new Sequence("TG"), new Sequence("AG"), new Sequence("AC"), new Sequence("AT"), new Sequence("CA"), new Sequence("GT"), new Sequence("GA")};
        Arrays.sort(objectArray);
        System.out.println(Arrays.toString(objectArray));
    }

    public static void test3() {
        long l = 0x1B1B1B1BL;
        Sequence sequence = new Sequence(l, 16);
        System.out.println(sequence.getString());
        sequence = new Sequence(l, 25);
        System.out.println(sequence.getString());
        Sequence sequence2 = new Sequence(l, 4);
        System.out.println(sequence2.getString());
    }

    public static void test1() {
        SequenceTest.test("aattggccaaaattggccaaaattggccaa");
        SequenceTest.test("ttggccaa");
        SequenceTest.test("ttggccaattggccaattggccaattggccaa");
    }

    public static void test2() {
        String string = "aaaa";
        Sequence sequence = new Sequence(string, 0, string.length());
        System.out.println("==============test2=================");
        System.out.println("value:" + sequence.getValue());
        System.out.println("string:" + sequence.getString());
        System.out.println("length:" + sequence.getLength());
    }

    public static void test(String string) {
        Sequence sequence = new Sequence(string);
        System.out.println("==============1=================");
        System.out.println("value:" + sequence.getValue());
        System.out.println("string:" + sequence.getString());
        System.out.println("length:" + sequence.getLength());
        Sequence sequence2 = new Sequence(sequence.getValue(), string.length());
        System.out.println("==============2=================");
        System.out.println("value:" + sequence2.getValue());
        System.out.println("string:" + sequence2.getString());
        System.out.println("length:" + sequence2.getLength());
        Sequence sequence3 = new Sequence(sequence.getString(), 0, string.length());
        System.out.println("==============3=================");
        System.out.println("value:" + sequence3.getValue());
        System.out.println("string:" + sequence3.getString());
        System.out.println("length:" + sequence3.getLength());
    }

    public static void test_reversed() {
        String string = "AAAACGT";
        Sequence sequence = new Sequence(string, 0, string.length());
        System.out.println("==============test2=================");
        System.out.println("value:" + sequence.getValue());
        System.out.println("string:" + sequence.getString());
        System.out.println("length:" + sequence.getLength());
        Sequence sequence2 = sequence.getReverseComplement();
        System.out.println("==============test2=================");
        System.out.println("value:" + sequence2.getValue());
        System.out.println("string:" + sequence2.getString());
        System.out.println("length:" + sequence2.getLength());
    }

    public static void testFeatures() {
        String string = "CAGGACGTAAGCCTAACGTA";
        Sequence sequence = new Sequence(string, 0, string.length());
        byte by = 6;
        Map<String, Integer> map = Sequence.generateFeaturesMatrix(by);
        long l = System.currentTimeMillis();
        for (int i = 0; i < 1000000; ++i) {
            map = Sequence.getFeatures(sequence, by, map);
        }
        long l2 = System.currentTimeMillis();
        for (String string2 : map.keySet()) {
            System.out.println(string2 + ":" + map.get(string2));
        }
        System.out.println("Time taken to generate 1000,000 runs of " + by + "th order features for " + string.length() + "-char string: " + (l2 - l) / 1000L + " seconds");
    }

    public static void testGenerateFeaturesMatrix() {
        long l = System.currentTimeMillis();
        Map<String, Integer> map = Sequence.generateFeaturesMatrix((byte)10);
        long l2 = System.currentTimeMillis();
        System.out.println("Time taken to generate 10th order feature matrix is " + (l2 - l) / 1000L + " seconds");
    }
}

