## ----load package, message=FALSE----------------------------------------------
library(LinTInd)

## ----message=FALSE------------------------------------------------------------
data<-paste0(system.file("extdata",package = 'LinTInd'),"/CB_UMI")
fafile<-paste0(system.file("extdata",package = 'LinTInd'),"/V3.fasta")
cutsite<-paste0(system.file("extdata",package = 'LinTInd'),"/V3.cutSites")
celltype<-paste0(system.file("extdata",package = 'LinTInd'),"/celltype.tsv")
data<-read.table(data,sep="\t",header=TRUE)
ref<-ReadFasta(fafile)
cutsite<-read.table(cutsite,col.names = c("indx","start","end"))
celltype<-read.table(celltype,header=TRUE,stringsAsFactors=FALSE)

## -----------------------------------------------------------------------------
head(data,3)
ref
cutsite
head(celltype,3)

## ----find indels and generate array-form strings, message=FALSE---------------
scarinfo<-FindIndel(data=data,scarfull=ref,scar=cutsite,indel.coverage="All",type="test",cln=1)
scarinfo<-IndelForm(scarinfo,cln=1)

## ----IndelIdents, message=FALSE-----------------------------------------------
cellsinfo<-IndelIdents(scarinfo,method.use="umi.num",cln=1)

## ----IndelPlot----------------------------------------------------------------
IndelPlot(cellsinfo = cellsinfo)

## ----TagProcess---------------------------------------------------------------
tag<-TagProcess(cellsinfo$info,Cells=celltype)

## ----TagDist------------------------------------------------------------------
tag_dist=TagDist(tag,method = "Jaccard")
tag_dist

## ----BuildTree----------------------------------------------------------------
treeinfo<-BuildTree(tag)

## ----PlotTree-----------------------------------------------------------------
plotinfo<-PlotTree(treeinfo = treeinfo,data.extract = "TRUE",annotation = "TRUE")
plotinfo$p

## ----sessionInfo, echo=TRUE---------------------------------------------------
sessionInfo()

