## ---- include = FALSE----------------------------------------------------
knitr::opts_chunk$set(
    eval =  AnVIL::gcloud_exists(), collapse = TRUE, cache = TRUE
)
options(width=75)

## ---- eval = FALSE-------------------------------------------------------
#  if (!requireNamespace("BiocManager", quietly = TRUE))
#      install.packages("BiocManager", repos = "https://cran.r-project.org")
#  BiocManager::install("AnVIL")

## ---- message = FALSE, eval = TRUE, cache = FALSE------------------------
library(AnVIL)

## ----workspace-----------------------------------------------------------
#  avworkspace("bioconductor-rpci-anvil/Bioconductor-Workflow-DESeq2")

## ----workflows-----------------------------------------------------------
#  avworkflows()

## ----workflow------------------------------------------------------------
#  avworkflow("bioconductor-rpci-anvil/AnVILBulkRNASeq")

## ----configuration-------------------------------------------------------
#  config <- avworkflow_configuration_get()
#  config

## ----inputs_outputs------------------------------------------------------
#  inputs <- avworkflow_configuration_inputs(config)
#  inputs
#  
#  outputs <- avworkflow_configuration_outputs(config)
#  outputs

## ----change_input--------------------------------------------------------
#  inputs <-
#      inputs |>
#      mutate(
#          attribute = ifelse(
#              name == "salmon.transcriptome_index_name",
#              '"new_index_name"',
#              attribute
#          )
#      )
#  inputs

## ----update_config-------------------------------------------------------
#  new_config <- avworkflow_configuration_update(config, inputs)
#  new_config

## ----entityName----------------------------------------------------------
#  entityName <- avtable("participant_set") |>
#      pull(participant_set_id) |>
#      head(1)
#  avworkflow_run(new_config, entityName)

## ----run_not_dry---------------------------------------------------------
#  ## avworkflow_run(new_config, entityName, dry = FALSE)

## ----checking_workflow---------------------------------------------------
#  avworkflow_jobs()

## ----set_config----------------------------------------------------------
#  avworkflow_configuration_set(new_config)

## ----set_config_not_dry--------------------------------------------------
#  ## avworkflow_configuration_set(new_config, dry = FALSE)

## ----stop_workflow-------------------------------------------------------
#  avworkflow_stop() # dry = FALSE to stop
#  
#  avworkflow_jobs()

## ----files---------------------------------------------------------------
#  avworkflow_files()

## ----localize------------------------------------------------------------
#  avworkflow_localize(type = "output") # dry = FALSE to localize

## ----sessionInfo---------------------------------------------------------
#  sessionInfo()

