## ---- echo = FALSE------------------------------------------------------------
library(knitr)
knitr::opts_chunk$set(
    error = FALSE,
    tidy  = FALSE,
    message = FALSE,
    warning = FALSE,
    fig.align = "center",
    dev = "jpeg"
)
options(width = 80)

## ---- echo = FALSE, message = FALSE-------------------------------------------
library(simplifyEnrichment)
mat = readRDS(system.file("extdata", "random_GO_BP_sim_mat.rds", package = "simplifyEnrichment"))
go_id = rownames(mat)

## ---- eval = FALSE------------------------------------------------------------
#  library(simplifyEnrichment)
#  set.seed(888)
#  go_id = random_GO(500)

## ---- eval = FALSE------------------------------------------------------------
#  mat = GO_similarity(go_id)

## ---- eval = FALSE------------------------------------------------------------
#  GO_similarity(go_id, measure = "Wang")

## ---- fig.width = 7*1.2, fig.height = 4*1.2-----------------------------------
df = simplifyGO(mat)

## -----------------------------------------------------------------------------
head(df)

## -----------------------------------------------------------------------------
sort(table(df$cluster))

## ---- eval = FALSE------------------------------------------------------------
#  split(df, df$cluster)

## -----------------------------------------------------------------------------
binary_cut(mat)

## ---- eval = FALSE------------------------------------------------------------
#  cluster_terms(mat, method = "binary_cut")

## ---- fig.width = 10, fig.height = 7------------------------------------------
compare_clustering_methods(mat)

## ---- fig.width = 18, fig.height = 14, dev = "jpeg"---------------------------
compare_clustering_methods(mat, plot_type = "heatmap")

## ---- eval = FALSE------------------------------------------------------------
#  set.seed(123)
#  compare_clustering_methods(mat)
#  set.seed(123)
#  compare_clustering_methods(mat, plot_type = "heatmap")

## ---- eval = FALSE------------------------------------------------------------
#  clt = cmp_make_clusters(mat) # just a list of cluster labels
#  cmp_make_plot(mat, clt)
#  cmp_make_plot(mat, clt, plot_type = "heatmap")

## ---- eval = FALSE------------------------------------------------------------
#  register_clustering_methods(
#      method1 = function(mat, ...) ...,
#      method2 = function(mat, ...) ...,
#      ...
#  )

## ---- fig.width=10, fig.height = 7--------------------------------------------
# perform functional enrichment on the signatures genes from cola anlaysis 
library(cola)
data(golub_cola) 
res = golub_cola["ATC:skmeans"]

library(hu6800.db)
x = hu6800ENTREZID
mapped_probes = mappedkeys(x)
id_mapping = unlist(as.list(x[mapped_probes]))

lt = functional_enrichment(res, k = 3, id_mapping = id_mapping)
names(lt)
head(lt[[1]][, 1:7])

## ---- fig.width=10, fig.height = 7, out.width = "100%"------------------------
simplifyGOFromMultipleLists(lt, padj_cutoff = 0.001)

## ---- eval = FALSE------------------------------------------------------------
#  lt2 = lapply(lt, function(x) structure(x$p.adjust, names = x$ID))
#  simplifyGOFromMultipleLists(lt2, padj_cutoff = 0.001)

## ---- eval = FALSE------------------------------------------------------------
#  lt3 = lapply(lt, function(x) x$ID[x$p.adjust < 0.001])
#  simplifyGOFromMultipleLists(lt3)

## -----------------------------------------------------------------------------
sessionInfo()

