## ----message=FALSE------------------------------------------------------------
options(rmarkdown.html_vignette.check_title = FALSE)
library(sesame)
sesameDataCacheAll()
library(dplyr)
library(tidyr)
library(SummarizedExperiment)
library(ggplot2)

## ----message=FALSE------------------------------------------------------------
se = sesameDataGet("MM285.10.tissues")[1:1000,] # use a random 1000 probes
colData(se)

## -----------------------------------------------------------------------------
se_ok = (checkLevels(assay(se), colData(se)$sex) &
    checkLevels(assay(se), colData(se)$tissue))
sum(se_ok)
se = se[se_ok,]

## -----------------------------------------------------------------------------
colData(se)$tissue <- relevel(factor(colData(se)$tissue), "Colon")
colData(se)$sex <- relevel(factor(colData(se)$sex), "Female")

## -----------------------------------------------------------------------------
smry = DML(se, ~tissue + sex)
smry

## -----------------------------------------------------------------------------
test_result = summaryExtractTest(smry)
colnames(test_result) # the column names, show four groups of statistics
head(test_result)

## -----------------------------------------------------------------------------
test_result %>% dplyr::filter(FPval_sex < 0.05, Eff_sex > 0.1) %>%
    select(FPval_sex, Eff_sex)

## -----------------------------------------------------------------------------
test_result %>%
    mutate(sex_specific =
        ifelse(FPval_sex < 0.05 & Eff_sex > 0.1, TRUE, FALSE)) %>%
    mutate(tissue_specific =
        ifelse(FPval_tissue < 0.05 & Eff_tissue > 0.1, TRUE, FALSE)) %>%
    select(sex_specific, tissue_specific) %>% table

## -----------------------------------------------------------------------------
ggplot(test_result) + geom_point(aes(Est_sexMale, -log10(Pval_sexMale)))

## -----------------------------------------------------------------------------
ggplot(test_result) + geom_point(aes(Est_tissueFat, -log10(Pval_tissueFat)))

## -----------------------------------------------------------------------------
smry2 = DML(se, ~ age + sex)
test_result2 = summaryExtractTest(smry2) %>% arrange(Est_age)

## -----------------------------------------------------------------------------
test_result2 %>% dplyr::select(Est_age, Pval_age) %>% tail # positive assoc.
df = data.frame(Age = colData(se)$age,
    BetaValue = assay(se)[rownames(test_result2)[nrow(test_result2)],])
ggplot(df, aes(Age, BetaValue)) + geom_smooth(method="lm") + geom_point()

## -----------------------------------------------------------------------------
dmContrasts(smry)                       # pick a contrast
merged = DMR(se, smry, "sexMale")       # merge CpGs to regions / segments

## -----------------------------------------------------------------------------
betas <- sesameDataGet('HM450.10.TCGA.PAAD.normal')

## ---- message=FALSE, fig.width=6, fig.height=5--------------------------------
visualizeRegion(
    'chr19',10260000,10380000, betas, platform='HM450',
    show.probeNames = FALSE)

## ---- message=FALSE, fig.width=6, fig.height=5--------------------------------
visualizeGene('DNMT1', betas, platform='HM450')

## ---- message=FALSE, fig.width=6----------------------------------------------
visualizeProbes(c("cg02382400", "cg03738669"), betas, platform='HM450')

## -----------------------------------------------------------------------------
sessionInfo()

