/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.tab;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import psidev.psi.mi.tab.PsimiTabException;
import psidev.psi.mi.tab.PsimiTabIterator;
import psidev.psi.mi.tab.model.BinaryInteraction;
import psidev.psi.mi.tab.model.Interactor;
import psidev.psi.mi.tab.model.builder.MitabParserUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PsimiTabReader
implements psidev.psi.mi.tab.io.PsimiTabReader {
    protected Collection<BinaryInteraction> read(BufferedReader reader) throws IOException, PsimiTabException {
        String completeLine;
        ArrayList<BinaryInteraction> interactions = new ArrayList<BinaryInteraction>();
        int lineIndex = 0;
        while ((completeLine = reader.readLine()) != null) {
            Object[] line = MitabParserUtils.quoteAwareSplit(completeLine, new char[]{'\t'}, false);
            if (line != null && line.length > 0 && line[0].startsWith("#")) {
                ++lineIndex;
                continue;
            }
            try {
                interactions.add(MitabParserUtils.buildBinaryInteraction((String[])line));
            }
            catch (Throwable e2) {
                this.handleError("Exception parsing line " + lineIndex + ": " + Arrays.toString(line), e2);
            }
            ++lineIndex;
        }
        return interactions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<BinaryInteraction> read(Reader reader) throws IOException, PsimiTabException {
        Collection<BinaryInteraction> interactions;
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(reader);
            interactions = this.read(bufferedReader);
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        return interactions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<BinaryInteraction> read(String s) throws IOException, PsimiTabException {
        Collection<BinaryInteraction> interactions;
        ByteArrayInputStream is = null;
        BufferedReader bufferedReader = null;
        try {
            is = new ByteArrayInputStream(s.getBytes());
            bufferedReader = new BufferedReader(new InputStreamReader(is));
            interactions = this.read(bufferedReader);
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            if (is != null) {
                is.close();
            }
        }
        return interactions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<BinaryInteraction> read(InputStream is) throws IOException, PsimiTabException {
        Collection<BinaryInteraction> interactions;
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(is));
            interactions = this.read(bufferedReader);
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        return interactions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<BinaryInteraction> read(File file) throws IOException, PsimiTabException {
        Collection<BinaryInteraction> interactions;
        FileReader reader = null;
        BufferedReader bufferedReader = null;
        try {
            reader = new FileReader(file);
            bufferedReader = new BufferedReader(reader);
            interactions = this.read(bufferedReader);
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            if (reader != null) {
                reader.close();
            }
        }
        return interactions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<BinaryInteraction> read(URL url) throws IOException, PsimiTabException {
        Collection<BinaryInteraction> interactions;
        InputStream is = null;
        BufferedReader bufferedReader = null;
        try {
            is = url.openStream();
            bufferedReader = new BufferedReader(new InputStreamReader(is));
            interactions = this.read(bufferedReader);
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            if (is != null) {
                is.close();
            }
        }
        return interactions;
    }

    @Override
    public BinaryInteraction readLine(String str2) throws PsimiTabException {
        BinaryInteraction<Interactor> interaction2 = null;
        Object[] line = MitabParserUtils.quoteAwareSplit(str2, new char[]{'\t'}, false);
        if (line.length > 0 && line[0].startsWith("#")) {
            return null;
        }
        try {
            interaction2 = MitabParserUtils.buildBinaryInteraction((String[])line);
        }
        catch (Throwable e2) {
            this.handleError("Exception parsing line :" + Arrays.toString(line), e2);
        }
        return interaction2;
    }

    @Override
    public Iterator<BinaryInteraction> iterate(Reader reader) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        return new PsimiTabIterator(bufferedReader);
    }

    @Override
    public Iterator<BinaryInteraction> iterate(String s) throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(s.getBytes());
        InputStreamReader reader = new InputStreamReader(is);
        BufferedReader bufferedReader = new BufferedReader(reader);
        return new PsimiTabIterator(bufferedReader);
    }

    @Override
    public Iterator<BinaryInteraction> iterate(InputStream is) throws IOException {
        InputStreamReader reader = new InputStreamReader(is);
        BufferedReader bufferedReader = new BufferedReader(reader);
        return new PsimiTabIterator(bufferedReader);
    }

    @Override
    public Iterator<BinaryInteraction> iterate(File file) throws IOException {
        FileReader reader = new FileReader(file);
        BufferedReader bufferedReader = new BufferedReader(reader);
        return new PsimiTabIterator(bufferedReader);
    }

    @Override
    public void handleError(String message, Throwable e2) throws PsimiTabException {
        throw new PsimiTabException(message, e2);
    }
}

