/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.query.wrapperL3undirected;

import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.Control;
import org.biopax.paxtools.model.level3.Entity;
import org.biopax.paxtools.model.level3.Interaction;
import org.biopax.paxtools.query.model.AbstractNode;
import org.biopax.paxtools.query.model.Graph;
import org.biopax.paxtools.query.wrapperL3undirected.EdgeL3;
import org.biopax.paxtools.query.wrapperL3undirected.EventWrapper;
import org.biopax.paxtools.query.wrapperL3undirected.GraphL3Undirected;

public class InteractionWrapper
extends EventWrapper {
    private Interaction interaction;

    protected InteractionWrapper(Interaction interaction2, GraphL3Undirected graph) {
        super(graph);
        if (interaction2 instanceof Control) {
            throw new IllegalArgumentException("Control objects should be wrapped with ControlWrapper.");
        }
        this.interaction = interaction2;
    }

    @Override
    public void initUpstream() {
        for (Entity entity2 : this.interaction.getParticipant()) {
            this.addToUpstream(entity2, this.getGraph());
        }
        for (Control control2 : this.interaction.getControlledOf()) {
            this.addToUpstream(control2, this.getGraph());
        }
    }

    @Override
    public void initDownstream() {
        for (Entity entity2 : this.interaction.getParticipant()) {
            this.addToDownstream(entity2, this.getGraph());
        }
        for (Control control2 : this.interaction.getControlledOf()) {
            this.addToDownstream(control2, this.getGraph());
        }
    }

    @Override
    public boolean isTranscription() {
        return false;
    }

    protected void addToDownstream(BioPAXElement pe, Graph graph) {
        AbstractNode node = (AbstractNode)graph.getGraphObject(pe);
        if (node != null) {
            EdgeL3 edge = new EdgeL3(this, node, graph);
            edge.setTranscription(true);
            node.getUpstreamNoInit().add(edge);
            this.getDownstreamNoInit().add(edge);
        }
    }

    @Override
    protected void addToUpstream(BioPAXElement ele, Graph graph) {
        AbstractNode node = (AbstractNode)graph.getGraphObject(ele);
        if (node != null) {
            EdgeL3 edge = new EdgeL3(node, this, graph);
            node.getDownstreamNoInit().add(edge);
            this.getUpstreamNoInit().add(edge);
        }
    }

    @Override
    public String getKey() {
        return this.interaction.getRDFId();
    }

    public Interaction getInteraction() {
        return this.interaction;
    }
}

