/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.List;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.XMLChar;
import net.sf.saxon.sort.IntHashMap;
import net.sf.saxon.sort.IntIterator;
import net.sf.saxon.tinytree.CompressedWhitespace;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Whitespace;

public class CharacterMapExpander
extends ProxyReceiver {
    private IntHashMap charMap;
    private int min = Integer.MAX_VALUE;
    private int max = 0;
    private boolean mapsWhitespace = false;
    private boolean useNullMarkers = true;

    public void setCharacterMaps(List list) {
        this.charMap = new IntHashMap(64);
        for (int i = 0; i < list.size(); ++i) {
            IntHashMap intHashMap = (IntHashMap)list.get(i);
            IntIterator intIterator = intHashMap.keyIterator();
            while (intIterator.hasNext()) {
                int n = intIterator.next();
                if (n < this.min) {
                    this.min = n;
                }
                if (n > this.max) {
                    this.max = n;
                }
                if (!this.mapsWhitespace && Whitespace.isWhitespace(n)) {
                    this.mapsWhitespace = true;
                }
                this.charMap.put(n, intHashMap.get(n));
            }
        }
        if (this.min > 55296) {
            this.min = 55296;
        }
    }

    public void setUseNullMarkers(boolean bl) {
        this.useNullMarkers = bl;
    }

    public void attribute(int n, int n2, CharSequence charSequence, int n4, int n5) throws XPathException {
        CharSequence charSequence2 = this.map(charSequence, this.useNullMarkers);
        if (charSequence2 == charSequence) {
            super.attribute(n, n2, charSequence, n4, n5);
        } else {
            super.attribute(n, n2, charSequence2, n4, (n5 | 0x100) & 0xFFFFFFFB);
        }
    }

    public void characters(CharSequence charSequence, int n, int n2) throws XPathException {
        if ((n2 & 1) == 0) {
            CharSequence charSequence2 = this.map(charSequence, this.useNullMarkers);
            if (charSequence2 != charSequence) {
                n2 = (n2 | 0x100) & 0xFFFFFFFB;
            }
            super.characters(charSequence2, n, n2);
        } else {
            super.characters(charSequence, n, n2);
        }
    }

    private CharSequence map(CharSequence charSequence, boolean bl) {
        int n;
        if (!this.mapsWhitespace && charSequence instanceof CompressedWhitespace) {
            return charSequence;
        }
        boolean bl2 = false;
        int n2 = 0;
        while (n2 < charSequence.length()) {
            if ((n = charSequence.charAt(n2++)) < this.min || n > this.max) continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            return charSequence;
        }
        FastStringBuffer fastStringBuffer = new FastStringBuffer(charSequence.length() * 2);
        n = 0;
        while (n < charSequence.length()) {
            char c;
            if ((c = charSequence.charAt(n++)) >= this.min && c <= this.max) {
                if (XMLChar.isHighSurrogate(c)) {
                    char c2;
                    int n4;
                    String string;
                    if ((string = (String)this.charMap.get(n4 = XMLChar.supplemental(c, c2 = charSequence.charAt(n++)))) == null) {
                        fastStringBuffer.append(c);
                        fastStringBuffer.append(c2);
                        continue;
                    }
                    if (bl) {
                        fastStringBuffer.append('\u0000');
                        fastStringBuffer.append(string);
                        fastStringBuffer.append('\u0000');
                        continue;
                    }
                    fastStringBuffer.append(string);
                    continue;
                }
                String string = (String)this.charMap.get(c);
                if (string == null) {
                    fastStringBuffer.append(c);
                    continue;
                }
                if (bl) {
                    fastStringBuffer.append('\u0000');
                    fastStringBuffer.append(string);
                    fastStringBuffer.append('\u0000');
                    continue;
                }
                fastStringBuffer.append(string);
                continue;
            }
            fastStringBuffer.append(c);
        }
        return fastStringBuffer;
    }
}

