## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(echo = TRUE)

## ---- eval=FALSE--------------------------------------------------------------
#  # install from bioconductor
#  if (!requireNamespace("BiocManager", quietly = TRUE))
#    install.packages("BiocManager")
#  
#  BiocManager::install("pairkat")

## ---- message=F, warning = F, results='hide'----------------------------------
# load pairkat library
library(pairkat)
data("smokers")

## ---- message=F, warning = F--------------------------------------------------
phenotype <- colData(smokers)
head(phenotype)

## -----------------------------------------------------------------------------
pathways <- rowData(smokers)
head(pathways)[, 1:2]

## -----------------------------------------------------------------------------
metabolome <- assays(smokers)$metabolomics
head(metabolome)[, 1:3]

## -----------------------------------------------------------------------------
smokers <-
  SummarizedExperiment(
    assays = list(metabolomics = metabolome),
    rowData = pathways,
    colData = phenotype
  )

## -----------------------------------------------------------------------------
head(keggList("organism"))[, 2:3]

## -----------------------------------------------------------------------------
networks <- GatherNetworks(
  SE = smokers,
  keggID = "kegg_id",
  species = "hsa",
  minPathwaySize = 5
)

## ---- message = F, warning = F------------------------------------------------
# run PaIRKAT
output <- PaIRKAT(log_FEV1_FVC_ratio ~ age, 
                  networks = networks)


## -----------------------------------------------------------------------------
library(dplyr)
# view formula call
output$call

# view results
output$results %>% arrange(p.value) %>% head()

## -----------------------------------------------------------------------------
plotNetworks(networks = networks, 
             pathway = "Glycerophospholipid metabolism")

## -----------------------------------------------------------------------------
sessionInfo()

