## ---- eval=FALSE--------------------------------------------------------------
#  if (!requireNamespace("BiocManager", quietly = TRUE))
#       install.packages("BiocManager")
#  # orthogene is only available on Bioconductor>=3.14
#  if(BiocManager::version()<"3.14") BiocManager::install(version = "devel")
#  
#  BiocManager::install("orthogene")

## ----setup--------------------------------------------------------------------
library(orthogene)

data("exp_mouse")
# Setting to "homologene" for the purposes of quick demonstration.
# We generally recommend using method="gprofiler" (default).
method <- "homologene"  

## -----------------------------------------------------------------------------
matches <- orthogene::infer_species(gene_df = exp_mouse)

## -----------------------------------------------------------------------------
exp_rat <- orthogene::convert_orthologs(gene_df = exp_mouse, 
                                        input_species = "mouse", 
                                        output_species = "rat",
                                        method = "homologene")

## -----------------------------------------------------------------------------
matches <- orthogene::infer_species(gene_df = exp_rat)

## -----------------------------------------------------------------------------
exp_human <- orthogene::convert_orthologs(gene_df = exp_mouse, 
                                          input_species = "mouse", 
                                          output_species = "human",
                                          method = "homologene")

## -----------------------------------------------------------------------------
matches <- orthogene::infer_species(gene_df = exp_human)

## -----------------------------------------------------------------------------
matches <- orthogene::infer_species(gene_df = exp_human, 
                                    test_species = "homologene")

## ----Session Info-------------------------------------------------------------
utils::sessionInfo()

