## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(dpi = 300)
knitr::opts_chunk$set(cache=FALSE)

## ---- echo = FALSE, hide=TRUE, message=FALSE, warning=FALSE-------------------
library('oppti')

## ---- eval = FALSE------------------------------------------------------------
#  if (!requireNamespace("BiocManager", quietly = TRUE))
#      install.packages("BiocManager")
#  BiocManager::install("oppti")

## ---- eval = FALSE------------------------------------------------------------
#  browseVignettes("oppti")

## ---- eval = TRUE-------------------------------------------------------------
set.seed(1)
cohort1.proteomes = as.data.frame(matrix(abs(rnorm(100*30)), 100, 30)) 
rownames(cohort1.proteomes) = paste('marker', 1:100, sep = '')
colnames(cohort1.proteomes) = paste('cohort1.sample', 1:30, sep = '')

## ---- eval = TRUE-------------------------------------------------------------
library('oppti')
result = oppti(cohort1.proteomes)

## ---- eval = TRUE-------------------------------------------------------------
cohort1.outlier.scores = result[[1]] 

## ---- eval = TRUE, echo = FALSE, size = 8-------------------------------------
knitr::kable(cohort1.outlier.scores[[1]][1:10,1:4], digits = 2, 
    caption = "Example matrix of the outlier scores, displayed for the
    first 10 proteins (rows) and the first 4 samples (columns)",
    row.names = TRUE)

## ---- eval = TRUE-------------------------------------------------------------
cohort1.normal.states = result[[2]] 

## ---- eval = TRUE, echo = FALSE, size = 8-------------------------------------
knitr::kable(cohort1.normal.states[[1]][1:10,1:4], digits = 2, 
    caption = "Example matrix of the normal states",
    row.names = TRUE)

## ---- eval = TRUE-------------------------------------------------------------
cohort1.markers.tests = result[[3]] 

## ---- eval = TRUE, echo = FALSE, size = 8-------------------------------------
knitr::kable(cohort1.markers.tests[[1]][1:10,], digits = 4, 
    caption = "Statistical significance of outlying markers",
    row.names = TRUE)

## ---- eval = TRUE-------------------------------------------------------------
cohort2.proteomes = as.data.frame(matrix(abs(rnorm(80*20)), 80, 20)) 
rownames(cohort2.proteomes) = paste('marker', 51:130, sep = '')
colnames(cohort2.proteomes) = paste('cohort2.sample', 31:50, sep = '')

## ---- eval = TRUE-------------------------------------------------------------
result = oppti(list(cohort1.proteomes,cohort2.proteomes))

## ---- eval = TRUE-------------------------------------------------------------
outlier.scores = result[[1]]

## ---- eval = TRUE-------------------------------------------------------------
cohort1.outlier.scores = outlier.scores[[1]]

## ---- eval = TRUE, echo = FALSE, size = 8-------------------------------------
knitr::kable(cohort1.outlier.scores[1:10,1:4], digits = 2, 
    caption = "Example outlier scores in cohort1",
    row.names = TRUE)

## ---- eval = TRUE-------------------------------------------------------------
cohort2.outlier.scores = outlier.scores[[2]]

## ---- eval = TRUE, echo = FALSE, size = 8-------------------------------------
knitr::kable(cohort2.outlier.scores[1:10,1:4], digits = 2, 
    caption = "Example outlier scores in cohort2",
    row.names = TRUE)

## ---- eval = FALSE------------------------------------------------------------
#  result = oppti(list(cohort1.proteomes,cohort2.proteomes), draw.sc.plots = TRUE,
#      panel.markers = rownames(cohort1.proteomes)[46:55])

## ---- eval = FALSE------------------------------------------------------------
#  result = oppti(list(cohort1.proteomes,cohort2.proteomes), draw.ou.plots = TRUE,
#      panel.markers = rownames(cohort1.proteomes)[46:55])

## ---- eval = FALSE------------------------------------------------------------
#  result = oppti(list(cohort1.proteomes,cohort2.proteomes),
#      draw.ou.markers = c('marker50', 'marker55'),
#      panel.markers = rownames(cohort1.proteomes)[46:55])

