## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(echo = TRUE)

## ---- message=FALSE-----------------------------------------------------------
library(SpatialExperiment)
library(STexampleData)
library(ggspavis)

## ---- message=FALSE-----------------------------------------------------------
# load data in SpatialExperiment format
spe <- Visium_mouseCoronal()

## ---- message=FALSE, out.width="60%"------------------------------------------
# add some values in 'colData' to annotate spots
colData(spe)$sum <- colSums(counts(spe))

# example plots
plotSpots(spe, annotate = "sum")
plotVisium(spe, fill = "sum", trans = "log", highlight = "in_tissue")

## ---- message=FALSE-----------------------------------------------------------
# load data in SpatialExperiment format
spe <- Visium_humanDLPFC()

## ---- message=FALSE, out.width="60%"------------------------------------------
# example plots
plotSpots(spe, annotate = "ground_truth", palette = "libd_layer_colors")
plotVisium(spe, fill = "ground_truth", highlight = "in_tissue")

## ---- message=FALSE-----------------------------------------------------------
# load data in SpatialExperiment format
spe <- seqFISH_mouseEmbryo()

## ---- message=FALSE, out.width="60%"------------------------------------------
# example plots
plotMolecules(spe, molecule = "Sox2")

