## -----------------------------------------------------------------------------
suppressPackageStartupMessages(library(genbankr))
smpfile = system.file("sample.gbk", package="genbankr")
gb = readGenBank(smpfile)
gb

## -----------------------------------------------------------------------------
genes(gb)

## ---- results='hide'----------------------------------------------------------
cds(gb)
exons(gb)
transcripts(gb)

## ---- results='hide'----------------------------------------------------------
variants(gb)
otherFeatures(gb)


## -----------------------------------------------------------------------------
accession(gb)
vers(gb)

## -----------------------------------------------------------------------------
seqinfo(gb)

## -----------------------------------------------------------------------------
getSeq(gb)

## -----------------------------------------------------------------------------
pg = parseGenBank(smpfile)
str(pg, max.level = 1)

## -----------------------------------------------------------------------------
gbf = readGenBank(smpfile, ret.seq = FALSE)
gbf

## -----------------------------------------------------------------------------
gbkfile = GenBankFile(smpfile)
gb2 = import(gbkfile)

## -----------------------------------------------------------------------------
gba = GBAccession("U49845.1")
gba

## -----------------------------------------------------------------------------
readGenBank(gba, partial=TRUE)

## -----------------------------------------------------------------------------
getSeq(gbkfile)

## -----------------------------------------------------------------------------
parseGenBank(smpfile, ret.anno=FALSE)

## -----------------------------------------------------------------------------
gbr = readGenBank(smpfile)
tx = makeTxDbFromGenBank(gbr)
tx

