/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.image;

import edu.rit.image.BaseColorImage;
import edu.rit.image.InputBitStream;
import edu.rit.image.OutputBitStream;
import edu.rit.image.PJGImage;
import edu.rit.image.PJGImageFileFormatException;
import edu.rit.util.Range;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class PJGHueImage
extends BaseColorImage {
    public PJGHueImage() {
        super(2);
    }

    public PJGHueImage(int n, int n2, int[][] nArray) {
        super(2);
        this.setMatrix(n, n2, nArray);
    }

    public PJGImage.Writer prepareToWrite(OutputStream outputStream) throws IOException {
        return new HueWriter(outputStream);
    }

    public PJGImage.Reader prepareToRead(InputStream inputStream) throws IOException {
        return new HueReader(inputStream);
    }

    private void writeChannelData(OutputBitStream outputBitStream, int n, int n2, int n3, int n4, int n5) throws IOException {
        int n6 = n + n3;
        int n7 = n2 + n4;
        for (int i = n; i < n6; ++i) {
            int[] nArray = this.myMatrix[i];
            int n8 = 0;
            for (int j = n2; j < n7; ++j) {
                int n9 = nArray[j] >> n5 & 0xFF;
                int n10 = n9 - n8;
                n8 = n9;
                if (n10 < -42 || n10 > 42) {
                    outputBitStream.writeBits(0xF00 | n9, 12);
                    continue;
                }
                if (n10 < -10) {
                    outputBitStream.writeBits(0x380 | n10 + 10 & 0x3F, 10);
                    continue;
                }
                if (n10 > 10) {
                    outputBitStream.writeBits(0x380 | n10 - 11 & 0x3F, 10);
                    continue;
                }
                if (n10 < -2) {
                    outputBitStream.writeBits(0x60 | n10 + 2 & 0xF, 7);
                    continue;
                }
                if (n10 > 2) {
                    outputBitStream.writeBits(0x60 | n10 - 3 & 0xF, 7);
                    continue;
                }
                if (n10 < 0) {
                    outputBitStream.writeBits(8 | n10 & 3, 4);
                    continue;
                }
                if (n10 > 0) {
                    outputBitStream.writeBits(8 | n10 - 1 & 3, 4);
                    continue;
                }
                outputBitStream.writeBits(0, 1);
            }
        }
    }

    private void writePixelData(DataOutputStream dataOutputStream, int n, int n2, int n3, int n4) throws IOException {
        dataOutputStream.writeByte(8);
        dataOutputStream.writeInt(n);
        dataOutputStream.writeInt(n2);
        dataOutputStream.writeInt(n3);
        dataOutputStream.writeInt(n4);
        OutputBitStream outputBitStream = new OutputBitStream(dataOutputStream);
        this.writeChannelData(outputBitStream, n, n2, n3, n4, 16);
        this.writeChannelData(outputBitStream, n, n2, n3, n4, 8);
        this.writeChannelData(outputBitStream, n, n2, n3, n4, 0);
        outputBitStream.flush();
    }

    private void readChannelData(InputBitStream inputBitStream, int n, int n2, int n3, int n4, int n5) throws IOException {
        int n6 = n + n3;
        int n7 = n2 + n4;
        for (int i = n; i < n6; ++i) {
            int[] nArray = this.myMatrix[i];
            if (nArray == null) {
                nArray = new int[n7];
                this.myMatrix[i] = nArray;
            } else if (nArray.length < n7) {
                int[] nArray2 = new int[n7];
                System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
                nArray = nArray2;
                this.myMatrix[i] = nArray2;
            }
            int n8 = 0;
            for (int j = n2; j < n7; ++j) {
                int n9;
                int n10;
                if (inputBitStream.peekBits(1) == 0) {
                    inputBitStream.skipBits(1);
                    n10 = n8;
                } else if (inputBitStream.peekBits(2) == 2) {
                    inputBitStream.skipBits(2);
                    n9 = inputBitStream.readBits(2);
                    n9 = (n9 & 2) != 0 ? (n9 |= 0xFFFFFFFC) : ++n9;
                    n10 = n8 + n9;
                } else if (inputBitStream.peekBits(3) == 6) {
                    inputBitStream.skipBits(3);
                    n9 = inputBitStream.readBits(4);
                    n9 = (n9 & 8) != 0 ? (n9 | 0xFFFFFFF0) - 2 : (n9 += 3);
                    n10 = n8 + n9;
                } else if (inputBitStream.peekBits(4) == 14) {
                    inputBitStream.skipBits(4);
                    n9 = inputBitStream.readBits(6);
                    n9 = (n9 & 0x20) != 0 ? (n9 | 0xFFFFFFC0) - 10 : (n9 += 11);
                    n10 = n8 + n9;
                } else {
                    inputBitStream.skipBits(4);
                    n10 = inputBitStream.readBits(8);
                }
                nArray[j] = nArray[j] & ~(255 << n5) | n10 << n5;
                n8 = n10;
            }
        }
    }

    private void readPixelData(DataInputStream dataInputStream, int n, int n2, int n3, int n4) throws IOException {
        if (this.myMatrix == null) {
            this.myMatrix = new int[this.myHeight][];
        }
        InputBitStream inputBitStream = new InputBitStream(dataInputStream);
        this.readChannelData(inputBitStream, n, n2, n3, n4, 16);
        this.readChannelData(inputBitStream, n, n2, n3, n4, 8);
        this.readChannelData(inputBitStream, n, n2, n3, n4, 0);
    }

    private class HueReader
    extends PJGImage.Reader {
        int myRow;
        int myCol;
        int myRowLen;
        int myColLen;

        HueReader(InputStream inputStream) throws IOException {
            super(PJGHueImage.this, inputStream);
            this.getPixelDataSegmentParameters();
        }

        public void read() throws IOException {
            while (this.myNextSegmentType != -1) {
                this.readSegment();
            }
        }

        public Range getRowRange() {
            return this.myNextSegmentType == -1 ? null : new Range(this.myRow, this.myRow + this.myRowLen - 1);
        }

        public Range getColRange() {
            return this.myNextSegmentType == -1 ? null : new Range(this.myCol, this.myCol + this.myColLen - 1);
        }

        public void readSegment() throws IOException {
            if (this.myNextSegmentType == -1) {
                return;
            }
            PJGHueImage.this.readPixelData(this.myDis, this.myRow, this.myCol, this.myRowLen, this.myColLen);
            this.myNextSegmentType = this.myDis.read();
            this.getPixelDataSegmentParameters();
        }

        private void getPixelDataSegmentParameters() throws IOException {
            if (this.myNextSegmentType == -1) {
                return;
            }
            if (this.myNextSegmentType != 8) {
                throw new PJGImageFileFormatException("Invalid PJG pixel data segment type (= " + this.myNextSegmentType + ")");
            }
            this.myRow = this.myDis.readInt();
            if (0 > this.myRow || this.myRow >= PJGHueImage.this.myHeight) {
                throw new PJGImageFileFormatException("Invalid PJG pixel data segment row index (= " + this.myRow + ")");
            }
            this.myCol = this.myDis.readInt();
            if (0 > this.myCol || this.myCol >= PJGHueImage.this.myWidth) {
                throw new PJGImageFileFormatException("Invalid PJG pixel data segment column index (= " + this.myCol + ")");
            }
            this.myRowLen = this.myDis.readInt();
            if (1 > this.myRowLen || this.myRow + this.myRowLen > PJGHueImage.this.myHeight) {
                throw new PJGImageFileFormatException("Invalid PJG pixel data segment row count (= " + this.myRowLen + ")");
            }
            this.myColLen = this.myDis.readInt();
            if (1 > this.myColLen || this.myCol + this.myColLen > PJGHueImage.this.myWidth) {
                throw new PJGImageFileFormatException("Invalid PJG pixel data segment column count (= " + this.myColLen + ")");
            }
        }
    }

    private class HueWriter
    extends PJGImage.Writer {
        private HueWriter(OutputStream outputStream) throws IOException {
            super(PJGHueImage.this, outputStream);
        }

        public void write() throws IOException {
            PJGHueImage.this.writePixelData(this.myDos, 0, 0, PJGHueImage.this.myHeight, PJGHueImage.this.myWidth);
        }

        public void writeRowSlice(Range range) throws IOException {
            int n = range.lb();
            int n2 = range.ub();
            int n3 = range.length();
            int n4 = range.stride();
            if (0 > n || n2 >= PJGHueImage.this.myHeight) {
                throw new IndexOutOfBoundsException("PJGImage.Writer.writeRowSlice(): Image row range = 0.." + (PJGHueImage.this.myHeight - 1) + ", theRowRange = " + range);
            }
            if (n4 > 1) {
                throw new IllegalArgumentException("PJGImage.Writer.writeRowSlice(): theRowRange stride = " + n4 + " illegal");
            }
            PJGHueImage.this.writePixelData(this.myDos, n, 0, n3, PJGHueImage.this.myWidth);
        }

        public void writeColSlice(Range range) throws IOException {
            int n = range.lb();
            int n2 = range.ub();
            int n3 = range.length();
            int n4 = range.stride();
            if (0 > n || n2 >= PJGHueImage.this.myWidth) {
                throw new IndexOutOfBoundsException("PJGImage.Writer.writeColSlice(): Image column range = 0.." + (PJGHueImage.this.myWidth - 1) + ", theColRange = " + range);
            }
            if (n4 > 1) {
                throw new IllegalArgumentException("PJGImage.Writer.writeColSlice(): theColRange stride = " + n4 + " illegal");
            }
            PJGHueImage.this.writePixelData(this.myDos, 0, n, PJGHueImage.this.myHeight, n3);
        }

        public void writePatch(Range range, Range range2) throws IOException {
            int n = range.lb();
            int n2 = range.ub();
            int n3 = range.length();
            int n4 = range.stride();
            if (0 > n || n2 >= PJGHueImage.this.myHeight) {
                throw new IndexOutOfBoundsException("PJGImage.Writer.writePatch(): Image row range = 0.." + (PJGHueImage.this.myHeight - 1) + ", theRowRange = " + range);
            }
            if (n4 > 1) {
                throw new IllegalArgumentException("PJGImage.Writer.writePatch(): theRowRange stride = " + n4 + " illegal");
            }
            int n5 = range2.lb();
            int n6 = range2.ub();
            int n7 = range2.length();
            int n8 = range2.stride();
            if (0 > n5 || n6 >= PJGHueImage.this.myWidth) {
                throw new IndexOutOfBoundsException("PJGImage.Writer.writePatch(): Image column range = 0.." + (PJGHueImage.this.myWidth - 1) + ", theColRange = " + range2);
            }
            if (n8 > 1) {
                throw new IllegalArgumentException("PJGImage.Writer.writePatch(): theColRange stride = " + n8 + " illegal");
            }
            PJGHueImage.this.writePixelData(this.myDos, n, n5, n3, n7);
        }
    }
}

