## ---- echo=FALSE--------------------------------------------------------------
source(system.file('vignettes_inc.R', package='biodb'))

## -----------------------------------------------------------------------------
mybiodb <- biodb::newInst()

## -----------------------------------------------------------------------------
mybiodb$terminate()

## -----------------------------------------------------------------------------
mybiodb <- biodb::newInst()

## -----------------------------------------------------------------------------
mybiodb$getConfig()

## -----------------------------------------------------------------------------
x <- mybiodb$getConfig()$listKeys()

## ----keysDf, echo=FALSE, results='asis'---------------------------------------
knitr::kable(x, "pipe", caption="List of keys with some of their parameters")

## -----------------------------------------------------------------------------
mybiodb$getConfig()$getDescription('useragent')

## -----------------------------------------------------------------------------
mybiodb$getConfig()$get('useragent')

## -----------------------------------------------------------------------------
mybiodb$getConfig()$set('useragent', 'My application ; wizard@of.oz')
mybiodb$getConfig()$get('useragent')

## -----------------------------------------------------------------------------
mybiodb$getConfig()$enable('offline')
mybiodb$getConfig()$disable('offline')

## -----------------------------------------------------------------------------
mybiodb$getConfig()$getDefaultValue('useragent')

## -----------------------------------------------------------------------------
mybiodb$getConfig()$getAssocEnvVar('useragent')

## -----------------------------------------------------------------------------
mybiodb$getDbsInfo()

## -----------------------------------------------------------------------------
mybiodb$getDbsInfo()$get('mass.csv.file')

## -----------------------------------------------------------------------------
mybiodb$getFactory()

## -----------------------------------------------------------------------------
chebi.tsv <- system.file("extdata", "chebi_extract.tsv", package='biodb')
conn <- mybiodb$getFactory()$createConn('comp.csv.file', url=chebi.tsv)
conn

## -----------------------------------------------------------------------------
conn$getEntry('1018')

## -----------------------------------------------------------------------------
conn$searchForEntries(list(monoisotopic.mass=list(value=136.05, delta=0.1)))

## ---- echo=FALSE, results='asis'----------------------------------------------
make_vignette_ref('entries')

## -----------------------------------------------------------------------------
conn <- mybiodb$getFactory()$getConn('comp.csv.file')

## -----------------------------------------------------------------------------
mybiodb$getFactory()$deleteConn(conn)

## -----------------------------------------------------------------------------
mybiodb$getEntryFields()

## -----------------------------------------------------------------------------
mybiodb$getEntryFields()$get('monoisotopic.mass')

## -----------------------------------------------------------------------------
mybiodb$getPersistentCache()

## ---- echo=FALSE, results='asis'----------------------------------------------
make_vignette_ref('new_connector')

## -----------------------------------------------------------------------------
source(system.file("extdata", "ChebiExConn.R", package='biodb'))
source(system.file("extdata", "ChebiExEntry.R", package='biodb'))
mybiodb$loadDefinitions(system.file("extdata", "chebi_ex.yml", package='biodb'))
conn <- mybiodb$getFactory()$createConn('chebi.ex')

## -----------------------------------------------------------------------------
entry <- conn$getEntry('17001')

## -----------------------------------------------------------------------------
mybiodb$getPersistentCache()$fileExist(conn$getCacheId(), name='17001', ext=conn$getEntryFileExt())

## -----------------------------------------------------------------------------
mybiodb$getPersistentCache()$getFilePath(conn$getCacheId(), name='17001', ext=conn$getEntryFileExt())

## -----------------------------------------------------------------------------
conn$deleteAllEntriesFromPersistentCache()

## -----------------------------------------------------------------------------
mybiodb$getPersistentCache()$fileExist(conn$getCacheId(), name='17001', ext=conn$getEntryFileExt())

## -----------------------------------------------------------------------------
conn$deleteAllEntriesFromVolatileCache()

## -----------------------------------------------------------------------------
conn$deleteWholePersistentCache()

## -----------------------------------------------------------------------------
biodb::getLogger()

## -----------------------------------------------------------------------------
biodb::logInfo("%d entries have been processed.", 12)

## -----------------------------------------------------------------------------
biodb::logDebug("The file %s has been written.", 'myfile.txt')

## -----------------------------------------------------------------------------
biodb::logTrace("%d bytes written.", 1284902)

## -----------------------------------------------------------------------------
biodb::getLogger()$set_threshold(300)

## -----------------------------------------------------------------------------
biodb::logInfo("hello")

## -----------------------------------------------------------------------------
biodb::getLogger()$set_threshold(400)

## -----------------------------------------------------------------------------
biodb::logInfo("hello")

## -----------------------------------------------------------------------------
mybiodb$terminate()

## -----------------------------------------------------------------------------
sessionInfo()

