## ----setup, echo=FALSE--------------------------------------------------------
options(width=80)

## ---- message=FALSE, warning=FALSE--------------------------------------------
library(atena)
library(GenomicRanges)

## -----------------------------------------------------------------------------
bamfiles <- list.files(system.file("extdata", package="atena"),
                        pattern="*.bam", full.names=TRUE)
TE_annot <- readRDS(file = system.file("extdata", "Top28TEs.rds", 
                                        package="atena"))
empar <- ERVmapParam(bamfiles, teFeatures = TE_annot, singleEnd = TRUE, 
                        ignoreStrand = TRUE, suboptimalAlignmentCutoff=NA)
empar

## -----------------------------------------------------------------------------
bamfiles <- list.files(system.file("extdata", package="atena"),
                        pattern="*.bam", full.names=TRUE)
TE_annot <- readRDS(file = system.file("extdata", "Top28TEs.rds", 
                                        package="atena"))
gene_annot <- readRDS(file = system.file("extdata", "Top50genes.rds", 
                                        package="atena"))
tspar <- TelescopeParam(bfl=bamfiles, teFeatures=TE_annot, 
                        geneFeatures = gene_annot,
                        singleEnd = TRUE, ignoreStrand=TRUE)
tspar

## -----------------------------------------------------------------------------
bamfiles <- list.files(system.file("extdata", package="atena"),
                        pattern="*.bam", full.names=TRUE)
TE_annot <- readRDS(file = system.file("extdata", "Top28TEs.rds", 
                                        package="atena"))
ttpar <- TEtranscriptsParam(bamfiles, teFeatures = TE_annot, singleEnd = TRUE, 
                            ignoreStrand=TRUE, aggregateby = c("repName"))

ttpar

## -----------------------------------------------------------------------------
# Creating an example of gene annotations
annot_gen <- GRanges(seqnames = rep("2L",10),
                    ranges = IRanges(start = c(1,20,45,80,110,130,150,170,200,220),
                                    width = c(10,20,35,10,5,15,10,25,5,20)),
                    strand = "*", 
                    type = rep("exon",10))
# Setting gene ids
names(annot_gen) <- paste0("gene",c(rep(1,3),rep(2,4),rep(3,3)))
annot_gen
ttpar_gen <- TEtranscriptsParam(bamfiles, teFeatures = TE_annot, 
                                geneFeatures = annot_gen, singleEnd = TRUE, 
                                ignoreStrand=TRUE)
ttpar_gen

## -----------------------------------------------------------------------------
features(ttpar_gen)[!attributes(features(ttpar_gen))$isTE$isTE]

## ---- results='hide'----------------------------------------------------------
emq <- qtex(empar)

## -----------------------------------------------------------------------------
emq
colSums(assay(emq))

## ---- results='hide'----------------------------------------------------------
tsq <- qtex(tspar)

## -----------------------------------------------------------------------------
tsq
colSums(assay(tsq))

## ---- results='hide'----------------------------------------------------------
ttq <- qtex(ttpar)

## -----------------------------------------------------------------------------
ttq
colSums(assay(ttq))

## -----------------------------------------------------------------------------
nrow(ttq)

## ----session_info, cache=FALSE------------------------------------------------
sessionInfo()

