## ----style-knitr, eval=TRUE, echo=FALSE, results="asis"-----------------------------
BiocStyle::latex()

## ----include=FALSE------------------------------------------------------------------
library(knitr)
opts_chunk$set(
concordance = TRUE,
background = "#f3f3ff"
)

## ----req----------------------------------------------------------------------------
library("SparseSignatures")
data(ssm560_reduced)
head(ssm560_reduced)

## ----example_import-----------------------------------------------------------------
library("BSgenome.Hsapiens.1000genomes.hs37d5")
bsg = BSgenome.Hsapiens.1000genomes.hs37d5
data(mutation_categories)
head(mutation_categories)

## ----example_import_final_eval------------------------------------------------------
imported_data = import.trinucleotides.counts(data=ssm560_reduced,reference=bsg)
head(imported_data)

## ----image-1, fig.show='hide', fig.width=5, fig.height=5, results='hide'------------
patients.plot(trinucleotides_counts=imported_data,samples="PD10010a")

## ----patients_data------------------------------------------------------------------
data(patients)
head(patients)

## ----starting_betas,eval=FALSE------------------------------------------------------
#  starting_betas = startingBetaEstimation(x=patients,K=3:12,background_signature=background)

## ----lambda_range,eval=FALSE--------------------------------------------------------
#  lambda_range = lambdaRangeBetaEvaluation(x=patients,K=10,beta=starting_betas[[8,1]],
#                                           lambda_values=c(0.05,0.10))

## ----example_data-------------------------------------------------------------------
data(starting_betas_example)
data(lambda_range_example)

## ----cross_validation,eval=FALSE----------------------------------------------------
#  cv = nmfLassoCV(x=patients,K=3:10)

## ----example_data_cv----------------------------------------------------------------
data(cv_example)

## ----best_configuation_signatures---------------------------------------------------
beta = starting_betas_example[["5_signatures","Value"]]
res = nmfLasso(x = patients, K = 5, beta = beta, background_signature = background, seed = 12345)

## ----image-5, fig.show='hide', fig.width=5, fig.height=5, results='hide'------------
data(nmf_LassoK_example)
signatures = nmf_LassoK_example$beta
signatures.plot(beta=signatures, xlabels=FALSE)

## ----sessioninfo,results='asis',echo=FALSE------------------------------------------
toLatex(sessionInfo())

