## ----eval = TRUE, echo = TRUE, message = FALSE--------------------------------
library(RiboCrypt) # This package
library(ORFik)     # The backend package for RiboCrypt

## ----eval = TRUE, echo = TRUE, message = FALSE--------------------------------
 df <- RiboCrypt.template.experiment()
 cds <- loadRegion(df, "cds")
 cds # gene annotation
 df # let's look at libraries the experiment contains


## ----eval = TRUE, echo = TRUE, message = FALSE--------------------------------
df[4:6,]
df[which(df$libtype == "CAGE"),]
df[which(df$condition == "Mutant"),]


## ----eval = TRUE, echo = TRUE, message = FALSE--------------------------------

  multiOmicsPlot_ORFikExp(extendLeaders(extendTrailers(cds[3], 30), 30), annotation = cds,df = df[c(1,5,9,13),],
                        frames_type = "columns", custom_motif = "CTG")
 

## ----eval = TRUE, echo = TRUE, message = FALSE--------------------------------

  multiOmicsPlot_ORFikExp(extendLeaders(extendTrailers(cds[3], 30), 30), annotation = cds,df = df[which(df$libtype == "RFP")[1],],
                        frames_type = "lines")
 

## ----eval = TRUE, echo = TRUE, message = FALSE--------------------------------

  multiOmicsPlot_ORFikExp(extendLeaders(extendTrailers(cds[3], 30), 30), annotation = cds,df = df[which(df$libtype == "RFP")[1],],
                        frames_type = "lines", kmers = 6)
 

## ----eval = TRUE, echo = TRUE, message = FALSE--------------------------------

  multiOmicsPlot_ORFikExp(extendLeaders(extendTrailers(cds[3], 30), 30), annotation = cds,df = df[which(df$libtype == "RFP")[1],],
                        frames_type = "stacks", kmers = 6)
 

