## ----GenSetup, include = FALSE----------------------------------------------------------------------------------------
knitr::opts_chunk$set(
    collapse = TRUE,
    comment = "#>",
    crop = NULL ## Related to https://stat.ethz.ch/pipermail/bioc-devel/2020-April/016656.html
)

## ----vignetteSetup, echo=FALSE, message=FALSE, warning = FALSE--------------------------------------------------------
## Bib setup
library("RefManageR")

## Write bibliography information
bib <- c(
    R = citation(),
    BiocStyle = citation("BiocStyle")[1],
    knitr = citation("knitr")[1],
    RefManageR = citation("RefManageR")[1],
    rmarkdown = citation("rmarkdown")[1],
    sessioninfo = citation("sessioninfo")[1],
    testthat = citation("testthat")[1],
    ISAnalytics = citation("ISAnalytics")[1],
    VISPA2 = BibEntry(bibtype = "Article", 
         title = paste("VISPA2: a scalable pipeline for", 
                       "high-throughput identification and",
                       "annotation of vector integration sites"),
         author = "Giulio Spinozzi, Andrea Calabria, Stefano Brasca", 
         journaltitle = "BMC Bioinformatics", 
         date = "2017-11-25",
         doi = "10.1186/s12859-017-1937-9")
)

## ----echo=FALSE-------------------------------------------------------------------------------------------------------
inst_chunk_path <- system.file("rmd", "install_and_options.Rmd", 
                               package = "ISAnalytics")

## ----include=FALSE----------------------------------------------------------------------------------------------------
knitr::opts_chunk$set(echo = TRUE)

## ----eval=FALSE-------------------------------------------------------------------------------------------------------
#  if (!requireNamespace("BiocManager", quietly = TRUE))
#      install.packages("BiocManager")
#  BiocManager::install("ISAnalytics")

## ----eval=FALSE-------------------------------------------------------------------------------------------------------
#  if (!requireNamespace("BiocManager", quietly = TRUE))
#      install.packages("BiocManager")
#  
#  # The following initializes usage of Bioc devel
#  BiocManager::install(version='devel')
#  
#  BiocManager::install("ISAnalytics")

## ----eval=FALSE-------------------------------------------------------------------------------------------------------
#  if (!require(devtools)) {
#    install.packages("devtools")
#  }
#  devtools::install_github("calabrialab/ISAnalytics",
#                           ref = "RELEASE_3_14",
#                           dependencies = TRUE,
#                           build_vignettes = TRUE)

## ----eval=FALSE-------------------------------------------------------------------------------------------------------
#  if (!require(devtools)) {
#    install.packages("devtools")
#  }
#  devtools::install_github("calabrialab/ISAnalytics",
#                           ref = "master",
#                           dependencies = TRUE,
#                           build_vignettes = TRUE)

## ----OptVerbose, eval=FALSE-------------------------------------------------------------------------------------------
#  # DISABLE
#  options("ISAnalytics.verbose" = FALSE)
#  
#  # ENABLE
#  options("ISAnalytics.verbose" = TRUE)
#  

## ----OptWidg, eval=FALSE----------------------------------------------------------------------------------------------
#  # DISABLE HTML REPORTS
#  options("ISAnalytics.reports" = FALSE)
#  
#  # ENABLE HTML REPORTS
#  options("ISAnalytics.reports" = TRUE)

## ---------------------------------------------------------------------------------------------------------------------
library(ISAnalytics)

## ----echo=FALSE-------------------------------------------------------------------------------------------------------
sample_sparse_matrix <- tibble::tribble(
  ~ chr, ~ integration_locus, ~ strand, ~ GeneName, ~GeneStrand, 
  ~ exp1, ~ exp2, ~ exp3,
  "1", 12324, "+", "NFATC3", "+", 4553,5345,NA_integer_,
  "6", 657532, "+", "LOC100507487", "+", 76,545,5,
  "7", 657532, "+", "EDIL3", "-", NA_integer_,56,NA_integer_,
)
print(sample_sparse_matrix, width = Inf)

## ---------------------------------------------------------------------------------------------------------------------
fs_path <- system.file("extdata", "fs.zip", package = "ISAnalytics")
root <- unzip_file_system(fs_path, "fs")
withr::with_options(list(ISAnalytics.reports = FALSE), code = {
  af_path <- system.file("extdata", "asso.file.tsv.gz", 
                         package = "ISAnalytics")
  af <- import_association_file(af_path, root = root)
})

## ----echo=FALSE-------------------------------------------------------------------------------------------------------
print(head(af), width = Inf)

## ----results='hide'---------------------------------------------------------------------------------------------------
withr::with_options(list(ISAnalytics.reports = FALSE), {
    vispa_stats <- import_Vispa2_stats(
        association_file = af,
        join_with_af = FALSE
    )
})

## ----echo=FALSE-------------------------------------------------------------------------------------------------------
print(head(vispa_stats))

## ----message=FALSE, results='hide'------------------------------------------------------------------------------------
matrix_path <- fs::path(root,
                        "PJ01",
                        "quantification",
                        "POOL01-1",
                        "PJ01_POOL01-1_seqCount_matrix.no0.annotated.tsv.gz")
matrix <- import_single_Vispa2Matrix(matrix_path)

## ----echo=FALSE-------------------------------------------------------------------------------------------------------
matrix

## ---------------------------------------------------------------------------------------------------------------------
withr::with_options(list(ISAnalytics.reports = FALSE), {
    matrices <- import_parallel_Vispa2Matrices(af,
        c("seqCount", "fragmentEstimate"),
        mode = "AUTO"
    )
})

## ----echo=FALSE-------------------------------------------------------------------------------------------------------
print(head(matrices), width = Inf)

## ----reproduce3, echo=FALSE-------------------------------------------------------------------------------------------
## Session info
library("sessioninfo")
options(width = 120)
session_info()

## ----vignetteBiblio, results = "asis", echo = FALSE, warning = FALSE, message = FALSE---------------------------------
## Print bibliography
PrintBibliography(bib, .opts = list(hyperlink = "to.doc", style = "html"))

