## ----GenSetup, include = FALSE----------------------------------------------------------------------------------------
knitr::opts_chunk$set(
    collapse = TRUE,
    comment = "#>",
    crop = NULL
    ## Related to
    ## https://stat.ethz.ch/pipermail/bioc-devel/2020-April/016656.html
)

## ----vignetteSetup, echo=FALSE, message=FALSE, warning = FALSE--------------------------------------------------------
## Bib setup
library("RefManageR")

## Write bibliography information
bib <- c(
    R = citation(),
    BiocStyle = citation("BiocStyle")[1],
    knitr = citation("knitr")[1],
    RefManageR = citation("RefManageR")[1],
    rmarkdown = citation("rmarkdown")[1],
    sessioninfo = citation("sessioninfo")[1],
    testthat = citation("testthat")[1],
    ISAnalytics = citation("ISAnalytics")[1]
)

## ----echo=FALSE-------------------------------------------------------------------------------------------------------
inst_chunk_path <- system.file("rmd", "install_and_options.Rmd", package = "ISAnalytics")

## ----include=FALSE----------------------------------------------------------------------------------------------------
knitr::opts_chunk$set(echo = TRUE)

## ----eval=FALSE-------------------------------------------------------------------------------------------------------
#  if (!requireNamespace("BiocManager", quietly = TRUE))
#      install.packages("BiocManager")
#  BiocManager::install("ISAnalytics")

## ----eval=FALSE-------------------------------------------------------------------------------------------------------
#  if (!requireNamespace("BiocManager", quietly = TRUE))
#      install.packages("BiocManager")
#  
#  # The following initializes usage of Bioc devel
#  BiocManager::install(version='devel')
#  
#  BiocManager::install("ISAnalytics")

## ----eval=FALSE-------------------------------------------------------------------------------------------------------
#  if (!require(devtools)) {
#    install.packages("devtools")
#  }
#  devtools::install_github("calabrialab/ISAnalytics",
#                           ref = "RELEASE_3_14",
#                           dependencies = TRUE,
#                           build_vignettes = TRUE)

## ----eval=FALSE-------------------------------------------------------------------------------------------------------
#  if (!require(devtools)) {
#    install.packages("devtools")
#  }
#  devtools::install_github("calabrialab/ISAnalytics",
#                           ref = "master",
#                           dependencies = TRUE,
#                           build_vignettes = TRUE)

## ----OptVerbose, eval=FALSE-------------------------------------------------------------------------------------------
#  # DISABLE
#  options("ISAnalytics.verbose" = FALSE)
#  
#  # ENABLE
#  options("ISAnalytics.verbose" = TRUE)
#  

## ----OptWidg, eval=FALSE----------------------------------------------------------------------------------------------
#  # DISABLE HTML REPORTS
#  options("ISAnalytics.reports" = FALSE)
#  
#  # ENABLE HTML REPORTS
#  options("ISAnalytics.reports" = TRUE)

## ---------------------------------------------------------------------------------------------------------------------
library(ISAnalytics)

## ----echo=FALSE-------------------------------------------------------------------------------------------------------
ex_coll <- tibble::tribble(
  ~ chr, ~ integration_locus, ~ strand, ~ seqCount, ~ CompleteAmplificationID,
  ~ SubjectID, ~ ProjectID, 
  "1", 123454,  "+", 653, "SAMPLE1", "SUBJ01", "PJ01",
  "1", 123454, "+", 456, "SAMPLE2", "SUBJ02", "PJ01"
)
knitr::kable(ex_coll, caption = paste("Example of collisions: the same",
                                      "integration (1, 123454, +) is found",
                                      "in 2 different independent samples",
                                      "((SUBJ01, PJ01) & (SUBJ02, PJ01))"))

## ---------------------------------------------------------------------------------------------------------------------
data("integration_matrices", package = "ISAnalytics")
data("association_file", package = "ISAnalytics")
## Multi quantification matrix
no_coll <- remove_collisions(x = integration_matrices,
                             association_file = association_file,
                             report_path = NULL)
## Matrix list
separated <- separate_quant_matrices(integration_matrices)
no_coll_list <- remove_collisions(x = separated,
                             association_file = association_file,
                             report_path = NULL)
## Only sequence count
no_coll_single <- remove_collisions(x = separated$seqCount,
                             association_file = association_file,
                             quant_cols = c(seqCount = "Value"),
                             report_path = NULL)

## ----realign----------------------------------------------------------------------------------------------------------
other_realigned <- realign_after_collisions(
  sc_matrix = no_coll_single,
  other_matrices = list(fragmentEstimate = separated$fragmentEstimate)
)

## ----reproduce3, echo=FALSE-------------------------------------------------------------------------------------------
## Session info
library("sessioninfo")
options(width = 120)
session_info()

## ----vignetteBiblio, results = "asis", echo = FALSE, warning = FALSE, message = FALSE---------------------------------
## Print bibliography
PrintBibliography(bib, .opts = list(hyperlink = "to.doc", style = "html"))

