## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
    collapse = TRUE,
    comment = "#>",
    crop = NULL
    ## Related to
    ## https://stat.ethz.ch/pipermail/bioc-devel/2020-April/016656.html
)

## ----vignetteSetup, echo=FALSE, message=FALSE, warning = FALSE----------------
## Bib setup
library("RefManageR")

## Write bibliography information
bib <- c(
    R = citation(),
    BiocStyle = citation("BiocStyle")[1],
    knitr = citation("knitr")[1],
    RefManageR = citation("RefManageR")[1],
    rmarkdown = citation("rmarkdown")[1],
    sessioninfo = citation("sessioninfo")[1],
    testthat = citation("testthat")[1],
    ISAnalytics = citation("ISAnalytics")[1]
)

## ----echo=FALSE---------------------------------------------------------------
inst_chunk_path <- system.file("rmd", "install_and_options.Rmd", package = "ISAnalytics")

## ----include=FALSE------------------------------------------------------------
knitr::opts_chunk$set(echo = TRUE)

## ----eval=FALSE---------------------------------------------------------------
#  if (!requireNamespace("BiocManager", quietly = TRUE))
#      install.packages("BiocManager")
#  BiocManager::install("ISAnalytics")

## ----eval=FALSE---------------------------------------------------------------
#  if (!requireNamespace("BiocManager", quietly = TRUE))
#      install.packages("BiocManager")
#  
#  # The following initializes usage of Bioc devel
#  BiocManager::install(version='devel')
#  
#  BiocManager::install("ISAnalytics")

## ----eval=FALSE---------------------------------------------------------------
#  if (!require(devtools)) {
#    install.packages("devtools")
#  }
#  devtools::install_github("calabrialab/ISAnalytics",
#                           ref = "RELEASE_3_14",
#                           dependencies = TRUE,
#                           build_vignettes = TRUE)

## ----eval=FALSE---------------------------------------------------------------
#  if (!require(devtools)) {
#    install.packages("devtools")
#  }
#  devtools::install_github("calabrialab/ISAnalytics",
#                           ref = "master",
#                           dependencies = TRUE,
#                           build_vignettes = TRUE)

## ----OptVerbose, eval=FALSE---------------------------------------------------
#  # DISABLE
#  options("ISAnalytics.verbose" = FALSE)
#  
#  # ENABLE
#  options("ISAnalytics.verbose" = TRUE)
#  

## ----OptWidg, eval=FALSE------------------------------------------------------
#  # DISABLE HTML REPORTS
#  options("ISAnalytics.reports" = FALSE)
#  
#  # ENABLE HTML REPORTS
#  options("ISAnalytics.reports" = TRUE)

## ----echo=FALSE---------------------------------------------------------------
library(ISAnalytics)
print(default_meta_agg(), width = Inf)

## -----------------------------------------------------------------------------
data("association_file", package = "ISAnalytics")
aggregated_meta <- aggregate_metadata(association_file = association_file)

## ----echo=FALSE---------------------------------------------------------------
print(aggregated_meta)

## -----------------------------------------------------------------------------
data("integration_matrices", package = "ISAnalytics")
data("association_file", package = "ISAnalytics")
aggreg <- aggregate_values_by_key(
  x = integration_matrices, 
  association_file = association_file,
  value_cols = c("seqCount", "fragmentEstimate")
)

## ----echo=FALSE---------------------------------------------------------------
print(aggreg, width = Inf)

## -----------------------------------------------------------------------------
agg1 <- aggregate_values_by_key(
    x = integration_matrices,
    association_file = association_file,
    key = c("SubjectID", "ProjectID"),
    value_cols = c("seqCount", "fragmentEstimate")
)

## ----echo=FALSE---------------------------------------------------------------
print(agg1, width = Inf)

## -----------------------------------------------------------------------------
agg2 <- aggregate_values_by_key(
    x = integration_matrices,
    association_file = association_file,
    key = "SubjectID",
    lambda = list(mean = ~ mean(.x, na.rm = TRUE)),
    value_cols = c("seqCount", "fragmentEstimate")
)

## ----echo=FALSE---------------------------------------------------------------
print(agg2, width = Inf)

## -----------------------------------------------------------------------------
agg3 <- aggregate_values_by_key(
    x = integration_matrices,
    association_file = association_file,
    key = "SubjectID",
    lambda = list(describe = ~ list(psych::describe(.x))),
    value_cols = c("seqCount", "fragmentEstimate")
)

## ----echo=FALSE---------------------------------------------------------------
print(agg3, width = Inf)

## -----------------------------------------------------------------------------
agg4 <- aggregate_values_by_key(
    x = integration_matrices,
    association_file = association_file,
    key = "SubjectID",
    lambda = list(sum = sum, mean = mean),
    value_cols = c("seqCount", "fragmentEstimate")
)

## ----echo=FALSE---------------------------------------------------------------
print(agg4, width = Inf)

## -----------------------------------------------------------------------------
agg5 <- aggregate_values_by_key(
    x = integration_matrices,
    association_file = association_file,
    key = "SubjectID",
    lambda = list(sum = sum, mean = mean),
    group = c(mandatory_IS_vars()),
    value_cols = c("seqCount", "fragmentEstimate")
)

## ----echo=FALSE---------------------------------------------------------------
print(agg5, width = Inf)

## ----reproduce3, echo=FALSE-------------------------------------------------------------------------------------------
## Session info
library("sessioninfo")
options(width = 120)
session_info()

## ----vignetteBiblio, results = "asis", echo = FALSE, warning = FALSE, message = FALSE---------------------------------
## Print bibliography
PrintBibliography(bib, .opts = list(hyperlink = "to.doc", style = "html"))

