## ----setup, echo=FALSE, results="hide", include = FALSE-------------------------------------------
knitr::opts_chunk$set(tidy = FALSE, cache = FALSE, message = FALSE, error = FALSE, warning = TRUE)
options(width = 100)
load(system.file("extdata/Bioc_Pkg_Details.RData", package = "Herper"))

## ---- echo=F, out.width = "1000px", fig.align="center"--------------------------------------------
knitr::include_graphics(system.file("extdata/pkg_deps_bar_mask-1.png", package = "Herper"))

## ----getPackage, eval=FALSE-----------------------------------------------------------------------
#  if (!requireNamespace("BiocManager", quietly = TRUE)) {
#        install.packages("BiocManager")
#    }
#  BiocManager::install("Herper")

## -------------------------------------------------------------------------------------------------
library(Herper)

## ---- echo=F, eval=T------------------------------------------------------------------------------
tempdir2 <- function() {
    tempDir <- tempdir()
    if(dir.exists(tempDir)){
      tempDir <- file.path(tempDir,"rr")
    }
    tempDir <- gsub("\\", "/", tempDir, fixed = TRUE)
    tempDir
}

## ----installCondaTools, echo=T, eval=T------------------------------------------------------------
myMiniconda <- file.path(tempdir2(), "Test")
myMiniconda
install_CondaTools("samtools", "herper", pathToMiniConda = myMiniconda)

## ----updateCondaTools, echo=T, eval=T-------------------------------------------------------------

pathToConda <- install_CondaTools(c("salmon", "kallisto"), "herper", updateEnv = TRUE, pathToMiniConda = myMiniconda)

pathToConda

## ----versionCondaTools, echo=T, eval=T------------------------------------------------------------

pathToConda <- install_CondaTools("salmon<=1.3", "herper", updateEnv = TRUE, pathToMiniConda = myMiniconda)


## ----test_package---------------------------------------------------------------------------------

testPkg <- system.file("extdata/HerperTestPkg", package = "Herper")
install.packages(testPkg, type = "source", repos = NULL)
utils::packageDescription("HerperTestPkg", fields = "SystemRequirements")

## ----install_CondaSysReqs-------------------------------------------------------------------------

install_CondaSysReqs("HerperTestPkg", pathToMiniConda = myMiniconda)

## ----with_condaenv_SalmonEval,echo=TRUE,eval=FALSE------------------------------------------------
#  pathToSamtools <- file.path(pathToConda$pathToEnvBin,"samtools")
#  Res <- system2(command=pathToSamtools, args = "help",stdout = TRUE)
#  Res

## ----with_condaenv_Salmon, echo=FALSE, eval=TRUE--------------------------------------------------
if(!identical(.Platform$OS.type, "windows")){
pathToSamtools <- file.path(pathToConda$pathToEnvBin,"samtools")
Res <- system2(command=pathToSamtools, args = "help",stdout = TRUE)
cat(Res,sep = "\n")
}

## ----with_condaenv_SalmonWithCondaEnvEval,echo=TRUE,eval=FALSE,tidy=FALSE-------------------------
#  res <- with_CondaEnv("herper",
#                        system2(command="samtools",args = "help",stdout = TRUE),
#                        pathToMiniConda=myMiniconda)
#  res

## ----with_condaenv_SalmonWithCondaEnv, echo=FALSE, eval=TRUE--------------------------------------
if(!identical(.Platform$OS.type, "windows")){
  res <- with_CondaEnv("herper",
                      system2(command="samtools",args = "help",stdout = TRUE),
                      pathToMiniConda=myMiniconda)
  cat(res,sep = "\n")
}

## ----with_condaenv_SalmonLocalCondaEnv,echo=TRUE,eval=FALSE---------------------------------------
#  samtoolsHelp <- function(){
#    local_CondaEnv("herper", pathToMiniConda=myMiniconda)
#    helpMessage <- system2(command="samtools",args = "help",stdout = TRUE)
#    helpMessage
#  }
#  samtoolsHelp()

## ----with_condaenv_SalmonLocalCondaEnvEval, echo=FALSE, eval=TRUE---------------------------------
if(!identical(.Platform$OS.type, "windows")){
  samtoolsHelp <- function(){
    local_CondaEnv("herper",  pathToMiniConda=myMiniconda)
    helpMessage <- system2(command="samtools",args = "help",stdout = TRUE)
    cat(helpMessage,sep = "\n")
  }
  samtoolsHelp()
}

## ----with_condaenv_R------------------------------------------------------------------------------
library(seqCNA)
data(seqsumm_HCC1143)
try(rco <- readSeqsumm(tumour.data = seqsumm_HCC1143), silent = FALSE)

## ---- echo=T, eval=F------------------------------------------------------------------------------
#  install_CondaSysReqs(pkg="seqCNA",env="seqCNA_env",pathToMiniConda=myMiniconda)
#  rco <- with_CondaEnv(new="seqCNA_env",readSeqsumm(tumour.data=seqsumm_HCC1143)
#   ,pathToMiniConda = myMiniconda)
#  summary(rco)

## ---- echo=F, eval=T------------------------------------------------------------------------------
if(!identical(.Platform$OS.type, "windows")){
install_CondaSysReqs("seqCNA",env="seqCNA_env",pathToMiniConda=myMiniconda)
rco <- with_CondaEnv(new="seqCNA_env",readSeqsumm(tumour.data=seqsumm_HCC1143)
 ,pathToMiniConda = myMiniconda)
summary(rco)
}

## ----conda_search---------------------------------------------------------------------------------
conda_search("salmon", pathToMiniConda = myMiniconda)

## ----conda_search_nuance--------------------------------------------------------------------------
conda_search("salmon<=1.0", pathToMiniConda = myMiniconda)
conda_search("salmo", pathToMiniConda = myMiniconda)

## ----export---------------------------------------------------------------------------------------
yml_name <- paste0("herper_", format(Sys.Date(), "%Y%m%d"), ".yml")
export_CondaEnv("herper", yml_name, pathToMiniConda = myMiniconda)

## ----export_rename--------------------------------------------------------------------------------
yml_name <- paste0("herper_nodeps_", format(Sys.Date(), "%Y%m%d"), ".yml")
export_CondaEnv("herper", yml_name, depends = FALSE, pathToMiniConda = myMiniconda)

## ----import---------------------------------------------------------------------------------------
testYML <- system.file("extdata/test.yml",package="Herper")
import_CondaEnv(yml_import=testYML, pathToMiniConda = myMiniconda)

## ----list_CondaEnv--------------------------------------------------------------------------------
list_CondaEnv(pathToMiniConda = myMiniconda)

## ----list_CondaPkgs-------------------------------------------------------------------------------
list_CondaPkgs("my_test", pathToMiniConda = myMiniconda)

## ---- echo=F, eval=F, message=F, warning=F--------------------------------------------------------
#  unlink(dir(".", pattern = "herper_.*.yml"))

## ---- echo=F, eval=F, message=F, warning=F--------------------------------------------------------
#  myMiniconda <- file.path(tempdir(), "Test")
#  reticulate::conda_remove("herper", packages = NULL, conda = file.path(myMiniconda, "bin", "conda"))
#  reticulate::conda_remove("herper2", packages = NULL, conda = file.path(myMiniconda, "bin", "conda"))
#  reticulate::conda_remove("HerperTestPkg_0.1.0", packages = NULL, conda = file.path(myMiniconda, "bin", "conda"))
#  
#  if (file.exists(file.path(tempdir(), "r-miniconda"))) {
#      condaDir <- file.path(tempdir(), "r-miniconda")
#      reticulate::conda_remove("herper", packages = NULL, conda = file.path(condaDir, "bin", "conda"))
#      reticulate::conda_remove("herpertest", packages = NULL, conda = file.path(condaDir, "bin", "conda"))
#  }

## -------------------------------------------------------------------------------------------------
sessionInfo()

