/*
 * Decompiled with CFR 0.152.
 */
package ding.view;

import giny.view.Justification;
import giny.view.ObjectPosition;
import giny.view.Position;
import java.text.DecimalFormat;

public class ObjectPositionImpl
implements ObjectPosition {
    public static ObjectPosition DEFAULT_POSITION = new ObjectPositionImpl();
    private Position objectAnchor;
    private Position targetAnchor;
    private Justification justify;
    private double xOffset;
    private double yOffset;

    public ObjectPositionImpl() {
        this(Position.CENTER, Position.CENTER, Justification.JUSTIFY_CENTER, 0.0, 0.0);
    }

    public ObjectPositionImpl(ObjectPosition p) {
        this.targetAnchor = p.getTargetAnchor();
        this.objectAnchor = p.getAnchor();
        this.xOffset = p.getOffsetX();
        this.yOffset = p.getOffsetY();
        this.justify = p.getJustify();
    }

    public ObjectPositionImpl(Position targ, Position lab, Justification just, double x, double y) {
        this.targetAnchor = targ;
        this.objectAnchor = lab;
        this.justify = just;
        this.xOffset = x;
        this.yOffset = y;
    }

    public Position getAnchor() {
        return this.objectAnchor;
    }

    public Position getTargetAnchor() {
        return this.targetAnchor;
    }

    public Justification getJustify() {
        return this.justify;
    }

    public double getOffsetX() {
        return this.xOffset;
    }

    public double getOffsetY() {
        return this.yOffset;
    }

    public void setAnchor(Position p) {
        this.objectAnchor = p;
    }

    public void setTargetAnchor(Position p) {
        this.targetAnchor = p;
    }

    public void setJustify(Justification j) {
        this.justify = j;
    }

    public void setOffsetX(double d) {
        this.xOffset = d;
    }

    public void setOffsetY(double d) {
        this.yOffset = d;
    }

    public boolean equals(Object lp) {
        if (lp == null || !(lp instanceof ObjectPosition)) {
            return false;
        }
        ObjectPosition p = (ObjectPosition)lp;
        if (Math.abs(p.getOffsetX() - this.xOffset) > 1.0E-7) {
            return false;
        }
        if (Math.abs(p.getOffsetY() - this.yOffset) > 1.0E-7) {
            return false;
        }
        if (p.getAnchor() != this.objectAnchor) {
            return false;
        }
        if (p.getTargetAnchor() != this.targetAnchor) {
            return false;
        }
        return p.getJustify() == this.justify;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("target: ").append(this.targetAnchor.getName());
        sb.append("  label: ").append(this.objectAnchor.getName());
        sb.append("  justify: ").append(this.justify.getName());
        sb.append("  X offset: ").append(Double.toString(this.xOffset));
        sb.append("  Y offset: ").append(Double.toString(this.yOffset));
        return sb.toString();
    }

    public String shortString() {
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(2);
        StringBuilder sb = new StringBuilder();
        sb.append(this.targetAnchor.getShortName());
        sb.append(",");
        sb.append(this.objectAnchor.getShortName());
        sb.append(",");
        sb.append(this.justify.getShortName());
        sb.append(",");
        sb.append(df.format(this.xOffset));
        sb.append(",");
        sb.append(df.format(this.yOffset));
        return sb.toString();
    }
}

