/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.ui.editors.discrete;

import com.l2fprod.common.beans.editor.AbstractPropertyEditor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class CyComboBoxPropertyEditor
extends AbstractPropertyEditor {
    private static final Color BACKGROUND = Color.white;
    private static final Color NOT_SELECTED = new Color(51, 51, 255, 150);
    private static final Color SELECTED = Color.red;
    private static final Font SELECTED_FONT = new Font("SansSerif", 1, 12);
    private Object oldValue;
    private Icon[] icons;

    public CyComboBoxPropertyEditor() {
        this.editor = new JComboBox(){

            public void setSelectedItem(Object anObject) {
                CyComboBoxPropertyEditor.this.oldValue = this.getSelectedItem();
                super.setSelectedItem(anObject);
            }
        };
        final JComboBox combo = (JComboBox)this.editor;
        combo.setRenderer(new Renderer());
        combo.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                if (combo.getSelectedItem() == null && combo.getItemCount() != 0) {
                    combo.setSelectedIndex(0);
                    CyComboBoxPropertyEditor.this.firePropertyChange(CyComboBoxPropertyEditor.this.oldValue, combo.getItemAt(0));
                } else {
                    CyComboBoxPropertyEditor.this.firePropertyChange(CyComboBoxPropertyEditor.this.oldValue, combo.getSelectedItem());
                }
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }
        });
        combo.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    CyComboBoxPropertyEditor.this.firePropertyChange(CyComboBoxPropertyEditor.this.oldValue, combo.getSelectedItem());
                }
            }
        });
        combo.setSelectedIndex(-1);
    }

    public Object getValue() {
        Object selected = ((JComboBox)this.editor).getSelectedItem();
        if (selected instanceof Value) {
            return ((Value)selected).value;
        }
        return selected;
    }

    public void setValue(Object value) {
        JComboBox combo = (JComboBox)this.editor;
        Object current = null;
        int index = -1;
        int c = combo.getModel().getSize();
        for (int i = 0; i < c; ++i) {
            current = combo.getModel().getElementAt(i);
            if (value != current && (current == null || !current.equals(value))) continue;
            index = i;
            break;
        }
        ((JComboBox)this.editor).setSelectedIndex(index);
    }

    public void setAvailableValues(Object[] values) {
        JComboBox cbox = (JComboBox)this.editor;
        cbox.setModel(new DefaultComboBoxModel<Object>(values));
        if (cbox.getItemCount() != 0) {
            cbox.setSelectedIndex(0);
        }
    }

    public void setAvailableIcons(Icon[] icons) {
        this.icons = icons;
    }

    public static final class Value {
        private Object value;
        private Object visualValue;

        public Value(Object value, Object visualValue) {
            this.value = value;
            this.visualValue = visualValue;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            return this.value == o || this.value != null && this.value.equals(o);
        }

        public int hashCode() {
            return this.value == null ? 0 : this.value.hashCode();
        }
    }

    class Renderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1142732116479667701L;

        Renderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component component = super.getListCellRendererComponent((JList<?>)list, value instanceof Value ? ((Value)value).visualValue : value, index, isSelected, cellHasFocus);
            if (CyComboBoxPropertyEditor.this.icons != null && index >= 0 && component instanceof JLabel) {
                ((JLabel)component).setIcon(CyComboBoxPropertyEditor.this.icons[index]);
            }
            component.setForeground(NOT_SELECTED);
            component.setBackground(BACKGROUND);
            if (value == null) {
                component = new JLabel("Select Value!");
                ((JLabel)component).setFont(SELECTED_FONT);
                component.setForeground(SELECTED);
            } else if (((JComboBox)CyComboBoxPropertyEditor.this.editor).getItemCount() != 0 && value != null) {
                component = new JLabel(value.toString());
            }
            if (isSelected) {
                component.setForeground(SELECTED);
                ((JLabel)component).setFont(SELECTED_FONT);
            }
            return component;
        }
    }
}

