/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.readers;

import cytoscape.CyEdge;
import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.CytoscapeInit;
import cytoscape.data.CyAttributes;
import cytoscape.data.readers.AbstractGraphReader;
import cytoscape.data.readers.VisualStyleBuilder;
import cytoscape.data.readers.XGMMLException;
import cytoscape.data.readers.XGMMLParser;
import cytoscape.groups.CyGroup;
import cytoscape.groups.CyGroupManager;
import cytoscape.layout.CyLayoutAlgorithm;
import cytoscape.layout.LayoutAdapter;
import cytoscape.logger.CyLogger;
import cytoscape.task.TaskMonitor;
import cytoscape.util.FileUtil;
import cytoscape.util.PercentUtil;
import cytoscape.view.CyNetworkView;
import cytoscape.visual.ArrowShape;
import cytoscape.visual.VisualPropertyType;
import ding.view.DGraphView;
import giny.view.EdgeView;
import giny.view.GraphView;
import giny.view.NodeView;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.ParserAdapter;

public class XGMMLReader
extends AbstractGraphReader {
    protected static final String GRAPH = "graph";
    protected static final String NODE = "node";
    protected static final String EDGE = "edge";
    protected static final String GRAPHICS = "graphics";
    protected static final String LABEL = "label";
    protected static final String SOURCE = "source";
    protected static final String TARGET = "target";
    protected static final String RECTANGLE = "rectangle";
    protected static final String ELLIPSE = "ellipse";
    protected static final String LINE = "Line";
    protected static final String POINT = "point";
    protected static final String DIAMOND = "diamond";
    protected static final String HEXAGON = "hexagon";
    protected static final String OCTAGON = "octagon";
    protected static final String PARALELLOGRAM = "parallelogram";
    protected static final String TRIANGLE = "triangle";
    protected static final String VEE = "vee";
    protected static final String ROUNDED_RECTANGLE = "rounded_rectangle";
    protected static final String BOX = "box";
    protected static final String CIRCLE = "circle";
    protected static final String VELLIPSIS = "ver_ellipsis";
    protected static final String HELLIPSIS = "hor_ellipsis";
    protected static final String RHOMBUS = "rhombus";
    protected static final String PENTAGON = "pentagon";
    protected static final String CY_NAMESPACE = "http://www.cytoscape.org";
    private String networkName = null;
    private Double graphViewZoom;
    private Double graphViewCenterX;
    private Double graphViewCenterY;
    private InputStream networkStream;
    private XGMMLParser parser;
    private Properties prop = CytoscapeInit.getProperties();
    private String vsbSwitch = this.prop.getProperty("visualStyleBuilder");
    private TaskMonitor taskMonitor;
    private PercentUtil percentUtil;
    private int nextID = 0;
    private CyLogger logger = null;

    public XGMMLReader(String fileName) {
        this(fileName, null);
    }

    public XGMMLReader(InputStream is) {
        super("InputStream");
        this.networkStream = is;
        this.initialize();
    }

    public XGMMLReader(InputStream is, String name) {
        super(name);
        this.networkStream = is;
        this.initialize();
    }

    public XGMMLReader(String fileName, TaskMonitor monitor) {
        super(fileName);
        this.taskMonitor = monitor;
        this.percentUtil = new PercentUtil(3);
        this.networkStream = FileUtil.getInputStream(fileName, monitor);
        this.initialize();
    }

    public void setTaskMonitor(TaskMonitor monitor) {
        this.taskMonitor = monitor;
        this.percentUtil = new PercentUtil(3);
    }

    private void initialize() {
        this.logger = CyLogger.getLogger(XGMMLReader.class);
        boolean attemptRepair = Boolean.getBoolean("cytoscape.xgmml.repair.bare.ampersands");
        if (attemptRepair) {
            this.networkStream = new RepairBareAmpersandsInputStream(this.networkStream, 512);
        }
    }

    public void read() throws IOException {
        try {
            this.readXGMML();
        }
        catch (SAXException e) {
            if (this.taskMonitor != null) {
                this.taskMonitor.setException(e, e.getMessage());
            }
            throw new IOException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readXGMML() throws SAXException, IOException {
        try {
            block9: {
                try {
                    try {
                        if (this.taskMonitor != null) {
                            this.taskMonitor.setPercentCompleted(-1);
                            this.taskMonitor.setStatus("Reading XGMML data...");
                        }
                        SAXParserFactory spf = SAXParserFactory.newInstance();
                        SAXParser sp = spf.newSAXParser();
                        ParserAdapter pa = new ParserAdapter(sp.getParser());
                        this.parser = new XGMMLParser();
                        pa.setContentHandler(this.parser);
                        pa.setErrorHandler(this.parser);
                        pa.parse(new InputSource(this.networkStream));
                        this.networkName = this.parser.getNetworkName();
                    }
                    catch (OutOfMemoryError oe) {
                        System.gc();
                        throw new XGMMLException("Out of memory error caught! The network being loaded is too large for the current memory allocation.  Use the -Xmx flag for the java virtual machine to increase the amount of memory available, e.g. java -Xmx1G cytoscape.jar -p plugins ....");
                    }
                    catch (ParserConfigurationException e) {
                    }
                    catch (SAXParseException e) {
                        this.logger.error("XGMMLParser: fatal parsing error on line " + e.getLineNumber() + " -- '" + e.getMessage() + "'", e);
                        throw e;
                    }
                    Object var5_7 = null;
                    if (this.networkStream == null) break block9;
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    if (this.networkStream == null) throw throwable;
                    this.networkStream.close();
                    throw throwable;
                }
                this.networkStream.close();
            }
            Object var7_10 = null;
            this.networkStream = null;
            return;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            this.networkStream = null;
            throw throwable;
        }
    }

    public int[] getNodeIndicesArray() {
        return this.parser.getNodeIndicesArray();
    }

    public int[] getEdgeIndicesArray() {
        return this.parser.getEdgeIndicesArray();
    }

    public String getNetworkID() {
        return this.networkName;
    }

    public String getNetworkName() {
        return this.networkName;
    }

    public CyLayoutAlgorithm getLayoutAlgorithm() {
        return new LayoutAdapter(){

            public void doLayout(CyNetworkView networkView, TaskMonitor monitor) {
                if (networkView != null && networkView.getIdentifier() != null) {
                    Cytoscape.setCurrentNetworkView(networkView.getIdentifier());
                }
                XGMMLReader.this.layout(networkView);
            }
        };
    }

    private void layout(CyNetworkView myView) {
        if (myView == null || myView.nodeCount() == 0) {
            return;
        }
        boolean buildStyle = this.vsbSwitch == null || this.vsbSwitch.equals("on");
        VisualStyleBuilder graphStyle = new VisualStyleBuilder(this.parser.getNetworkName(), false);
        if (this.parser.getBackgroundColor() != null) {
            myView.setBackgroundPaint(this.parser.getBackgroundColor());
            graphStyle.setBackgroundColor(this.parser.getBackgroundColor());
        }
        this.layoutNodes(myView, graphStyle, buildStyle);
        this.layoutEdges(myView, graphStyle, buildStyle);
        if (buildStyle) {
            graphStyle.buildStyle();
        }
    }

    private void layoutNodes(GraphView myView, VisualStyleBuilder graphStyle, boolean buildStyle) {
        String label = null;
        int tempid = 0;
        NodeView view = null;
        HashMap<CyNode, Attributes> nodeGraphicsMap = this.parser.getNodeGraphics();
        for (CyNode node : nodeGraphicsMap.keySet()) {
            view = myView.getNodeView(node.getRootGraphIndex());
            if (label != null && view != null) {
                view.getLabel().setText(label);
            } else if (view != null) {
                view.getLabel().setText("node(" + tempid + ")");
                ++tempid;
            }
            if (nodeGraphicsMap == null || view == null) continue;
            this.layoutNodeGraphics(nodeGraphicsMap.get(node), view, graphStyle, buildStyle);
        }
    }

    private void layoutNodeGraphics(Attributes graphics, NodeView nodeView, VisualStyleBuilder graphStyle, boolean buildStyle) {
        float opacity;
        String opString;
        String nodeID = nodeView.getNode().getIdentifier();
        double x = XGMMLParser.getDoubleAttribute(graphics, "x");
        double y = XGMMLParser.getDoubleAttribute(graphics, "y");
        double h = XGMMLParser.getDoubleAttribute(graphics, "h");
        double w = XGMMLParser.getDoubleAttribute(graphics, "w");
        nodeView.setXPosition(x);
        nodeView.setYPosition(y);
        if (buildStyle && h != 0.0) {
            graphStyle.addProperty(nodeID, VisualPropertyType.NODE_HEIGHT, "" + h);
        }
        if (buildStyle && w != 0.0) {
            graphStyle.addProperty(nodeID, VisualPropertyType.NODE_WIDTH, "" + w);
        }
        CyAttributes nodeAttributes = Cytoscape.getNodeAttributes();
        if (buildStyle && XGMMLParser.getAttribute(graphics, "fill") != null) {
            String fillColor = XGMMLParser.getAttribute(graphics, "fill");
            graphStyle.addProperty(nodeID, VisualPropertyType.NODE_FILL_COLOR, fillColor);
        }
        if (buildStyle && XGMMLParser.getAttribute(graphics, "outline") != null) {
            String outlineColor = XGMMLParser.getAttribute(graphics, "outline");
            graphStyle.addProperty(nodeID, VisualPropertyType.NODE_BORDER_COLOR, outlineColor);
        }
        if (buildStyle && XGMMLParser.getAttribute(graphics, "width") != null) {
            String lineWidth = XGMMLParser.getAttribute(graphics, "width");
            graphStyle.addProperty(nodeID, VisualPropertyType.NODE_LINE_WIDTH, lineWidth);
        }
        if (buildStyle && XGMMLParser.getAttributeNS(graphics, "nodeTransparency", CY_NAMESPACE) != null) {
            opString = XGMMLParser.getAttributeNS(graphics, "nodeTransparency", CY_NAMESPACE);
            opacity = (float)Double.parseDouble(opString) * 255.0f;
            graphStyle.addProperty(nodeID, VisualPropertyType.NODE_OPACITY, "" + opacity);
        }
        if (buildStyle && XGMMLParser.getAttributeNS(graphics, "opacity", CY_NAMESPACE) != null) {
            opString = XGMMLParser.getAttributeNS(graphics, "opacity", CY_NAMESPACE);
            opacity = (float)Double.parseDouble(opString);
            graphStyle.addProperty(nodeID, VisualPropertyType.NODE_OPACITY, opString);
        }
        if (buildStyle && XGMMLParser.getAttributeNS(graphics, "nodeLabelFont", CY_NAMESPACE) != null) {
            String nodeLabelFont = XGMMLParser.getAttributeNS(graphics, "nodeLabelFont", CY_NAMESPACE);
            String[] items = nodeLabelFont.split("-");
            graphStyle.addProperty(nodeID, VisualPropertyType.NODE_FONT_SIZE, items[2]);
        }
        if (buildStyle && XGMMLParser.getAttributeNS(graphics, "borderLineType", CY_NAMESPACE) != null) {
            String borderLineType = XGMMLParser.getAttributeNS(graphics, "borderLineType", CY_NAMESPACE);
            graphStyle.addProperty(nodeID, VisualPropertyType.NODE_LINETYPE, borderLineType);
        }
        String type = XGMMLParser.getAttribute(graphics, "type");
        if (buildStyle && type != null) {
            if (type.equals(RHOMBUS)) {
                graphStyle.addProperty(nodeID, VisualPropertyType.NODE_SHAPE, PARALELLOGRAM);
            } else {
                graphStyle.addProperty(nodeID, VisualPropertyType.NODE_SHAPE, type);
            }
        }
    }

    private void layoutEdges(GraphView myView, VisualStyleBuilder graphStyle, boolean buildStyle) {
        Object label = null;
        boolean tempid = false;
        EdgeView view = null;
        HashMap<CyEdge, Attributes> edgeGraphicsMap = this.parser.getEdgeGraphics();
        if (edgeGraphicsMap == null) {
            return;
        }
        for (CyEdge edge : edgeGraphicsMap.keySet()) {
            view = myView.getEdgeView(edge.getRootGraphIndex());
            if (view != null) {
                this.layoutEdgeGraphics(edgeGraphicsMap.get(edge), view, graphStyle, buildStyle);
                continue;
            }
            myView.getGraphPerspective().hideEdge(edge);
        }
    }

    private void layoutEdgeGraphics(Attributes graphics, EdgeView edgeView, VisualStyleBuilder graphStyle, boolean buildStyle) {
        String value;
        String arrowColor;
        String arrowName;
        ArrowShape shape;
        Integer arrowType;
        CyAttributes edgeAttributes = Cytoscape.getEdgeAttributes();
        String edgeID = edgeView.getEdge().getIdentifier();
        if (buildStyle && XGMMLParser.getAttribute(graphics, "width") != null) {
            String lineWidth = XGMMLParser.getAttribute(graphics, "width");
            graphStyle.addProperty(edgeID, VisualPropertyType.EDGE_LINE_WIDTH, lineWidth);
        }
        if (buildStyle && XGMMLParser.getAttribute(graphics, "fill") != null) {
            String edgeColor = XGMMLParser.getAttribute(graphics, "fill");
            graphStyle.addProperty(edgeID, VisualPropertyType.EDGE_COLOR, edgeColor);
        }
        if (buildStyle && XGMMLParser.getAttributeNS(graphics, "sourceArrow", CY_NAMESPACE) != null) {
            arrowType = XGMMLParser.getIntegerAttributeNS(graphics, "sourceArrow", CY_NAMESPACE);
            shape = ArrowShape.getArrowShape(arrowType);
            arrowName = shape.getName();
            graphStyle.addProperty(edgeID, VisualPropertyType.EDGE_SRCARROW_SHAPE, arrowName);
        }
        if (buildStyle && XGMMLParser.getAttributeNS(graphics, "targetArrow", CY_NAMESPACE) != null) {
            arrowType = XGMMLParser.getIntegerAttributeNS(graphics, "targetArrow", CY_NAMESPACE);
            shape = ArrowShape.getArrowShape(arrowType);
            arrowName = shape.getName();
            graphStyle.addProperty(edgeID, VisualPropertyType.EDGE_TGTARROW_SHAPE, arrowName);
        }
        if (buildStyle && XGMMLParser.getAttributeNS(graphics, "sourceArrowColor", CY_NAMESPACE) != null) {
            arrowColor = XGMMLParser.getAttributeNS(graphics, "sourceArrowColor", CY_NAMESPACE);
            graphStyle.addProperty(edgeID, VisualPropertyType.EDGE_SRCARROW_COLOR, arrowColor);
        }
        if (buildStyle && XGMMLParser.getAttributeNS(graphics, "targetArrowColor", CY_NAMESPACE) != null) {
            arrowColor = XGMMLParser.getAttributeNS(graphics, "targetArrowColor", CY_NAMESPACE);
            graphStyle.addProperty(edgeID, VisualPropertyType.EDGE_TGTARROW_COLOR, arrowColor);
        }
        if (buildStyle && XGMMLParser.getAttributeNS(graphics, "edgeLineType", CY_NAMESPACE) != null) {
            value = XGMMLParser.getAttributeNS(graphics, "edgeLineType", CY_NAMESPACE);
            graphStyle.addProperty(edgeID, VisualPropertyType.EDGE_LINE_STYLE, value);
        }
        if (XGMMLParser.getAttributeNS(graphics, "curved", CY_NAMESPACE) != null) {
            value = XGMMLParser.getAttributeNS(graphics, "curved", CY_NAMESPACE);
            if (value.equals("STRAIGHT_LINES")) {
                edgeView.setLineType(2);
            } else if (value.equals("CURVED_LINES")) {
                edgeView.setLineType(1);
            }
        }
        if (XGMMLParser.getAttribute(graphics, "edgeHandleList") != null) {
            String[] handles = XGMMLParser.getAttribute(graphics, "edgeHandleList").split(";");
            for (int i = 0; i < handles.length; ++i) {
                String[] points = handles[i].split(",");
                double x = new Double(points[0]);
                double y = new Double(points[1]);
                Point2D.Double point = new Point2D.Double();
                point.setLocation(x, y);
                edgeView.getBend().addHandle(point);
            }
        }
    }

    public void doPostProcessing(CyNetwork network) {
        Point2D center;
        this.parser.setMetaData(network);
        CyNetworkView view = Cytoscape.getNetworkView(network.getIdentifier());
        HashMap<CyNode, List<CyNode>> groupMap = this.parser.getGroupMap();
        if (groupMap != null) {
            CyAttributes nodeAttributes = Cytoscape.getNodeAttributes();
            CyGroup newGroup = null;
            String viewer = null;
            for (CyNode groupNode : groupMap.keySet()) {
                List childList = (List)groupMap.get(groupNode);
                viewer = nodeAttributes.getStringAttribute(groupNode.getIdentifier(), "__groupViewer");
                if (view == null || view == Cytoscape.getNullNetworkView()) {
                    newGroup = CyGroupManager.createGroup(groupNode, (List<CyNode>)childList, null);
                    continue;
                }
                newGroup = CyGroupManager.getCyGroup(groupNode);
                if (newGroup == null) {
                    CyGroupManager.createGroup(groupNode, (List<CyNode>)childList, viewer);
                    continue;
                }
                CyGroupManager.setGroupViewer(newGroup, viewer, view, false);
            }
            if (view != null && view != Cytoscape.getNullNetworkView()) {
                CyGroupManager.setGroupViewer(newGroup, viewer, view, true);
            }
        }
        if (view == null || view == Cytoscape.getNullNetworkView()) {
            return;
        }
        Cytoscape.getVisualMappingManager().applyAppearances();
        Double zoomLevel = this.parser.getGraphViewZoomLevel();
        if (zoomLevel != null) {
            view.setZoom(zoomLevel);
        }
        if ((center = this.parser.getGraphViewCenter()) != null) {
            ((DGraphView)((Object)view)).setCenter(center.getX(), center.getY());
        }
    }

    private class RepairBareAmpersandsInputStream
    extends PushbackInputStream {
        private final byte[] encodedAmpersand;

        public RepairBareAmpersandsInputStream(InputStream in) {
            super(in);
            this.encodedAmpersand = new byte[]{97, 109, 112, 59};
        }

        public RepairBareAmpersandsInputStream(InputStream in, int size) {
            super(in, size);
            this.encodedAmpersand = new byte[]{97, 109, 112, 59};
        }

        public int read() throws IOException {
            byte[] b;
            int cnt;
            int c = super.read();
            if (c == 38 && (cnt = this.read(b = new byte[7])) > 0) {
                boolean isEntity = false;
                for (int i = 0; i < cnt && !isEntity; ++i) {
                    isEntity = b[i] == 59;
                }
                byte[] pb = new byte[cnt];
                for (int p = 0; p < cnt; ++p) {
                    pb[p] = b[p];
                }
                this.unread(pb);
                if (!isEntity) {
                    this.unread(this.encodedAmpersand);
                }
            }
            return c;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int cnt;
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || len < 0 || len > b.length - off) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            int c = -1;
            for (cnt = 0; cnt < len && (c = this.read()) != -1; ++cnt) {
                b[off] = (byte)c;
                ++off;
            }
            if (c == -1 && cnt == 0) {
                cnt = -1;
            }
            return cnt;
        }
    }
}

