/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glf.goodies;

import com.sun.glf.ImageLayer;
import com.sun.glf.Layer;
import com.sun.glf.LayerComposition;
import com.sun.glf.Position;
import com.sun.glf.goodies.CompositeOp;
import com.sun.glf.util.CompositionComponent;
import com.sun.glf.util.Toolbox;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import javax.swing.JFrame;

public class GaussianKernel
extends Kernel {
    private int radius;
    static final String USAGE = "java com.sun.glf.goodies.GaussianKernel <source image>";

    public GaussianKernel(int n) {
        super(2 * n + 1, 2 * n + 1, GaussianKernel.getGaussianKernel(n));
        this.radius = n;
    }

    public static float[] getGaussianKernel(int n) {
        int n2;
        int n3;
        float[] fArray = new float[(n * 2 + 1) * (n * 2 + 1)];
        double d = 0.0;
        int n4 = 2 * n + 1;
        double d2 = (double)n / 3.0;
        double d3 = 2.0 * Math.pow(d2, 2.0);
        double d4 = Math.PI * d3;
        for (n3 = 0; n3 < n4; ++n3) {
            for (n2 = 0; n2 < n4; ++n2) {
                fArray[n3 * n4 + n2] = (float)(Math.pow(Math.E, (double)(-((n2 - n) * (n2 - n) + (n3 - n) * (n3 - n))) / d3) / d4);
                d += (double)fArray[n3 * n4 + n2];
            }
        }
        for (n3 = 0; n3 < n4; ++n3) {
            for (n2 = 0; n2 < n4; ++n2) {
                int n5 = n3 * n4 + n2;
                fArray[n5] = (float)((double)fArray[n5] / d);
            }
        }
        return fArray;
    }

    public Kernel[] separateKernel() {
        int n;
        float[] fArray = new float[this.radius * 2 + 1];
        double d = 0.0;
        int n2 = 2 * this.radius + 1;
        double d2 = (double)this.radius / 3.0;
        double d3 = 2.0 * Math.pow(d2, 2.0);
        double d4 = Math.PI * d3;
        double d5 = Math.sqrt(d4);
        for (n = 0; n < n2; ++n) {
            fArray[n] = (float)(Math.pow(Math.E, (double)(-((n - this.radius) * (n - this.radius))) / d3) / d5);
            d += (double)fArray[n];
        }
        n = 0;
        while (n < n2) {
            int n3 = n++;
            fArray[n3] = (float)((double)fArray[n3] / d);
        }
        Kernel kernel = new Kernel(n2, 1, fArray);
        Kernel kernel2 = new Kernel(1, n2, fArray);
        return new Kernel[]{kernel, kernel2};
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.out.println(USAGE);
            System.exit(0);
        }
        BufferedImage bufferedImage = Toolbox.loadImage(stringArray[0], 3);
        int n = 25;
        if (stringArray.length > 1) {
            n = Integer.parseInt(stringArray[1]);
        }
        System.out.println("Using radius : " + n);
        GaussianKernel gaussianKernel = new GaussianKernel(n);
        Kernel[] kernelArray = gaussianKernel.separateKernel();
        ConvolveOp convolveOp = new ConvolveOp(kernelArray[0]);
        ConvolveOp convolveOp2 = new ConvolveOp(kernelArray[1]);
        CompositeOp compositeOp = new CompositeOp(convolveOp, convolveOp2);
        Dimension dimension = new Dimension(bufferedImage.getWidth(), bufferedImage.getHeight() * 3);
        LayerComposition layerComposition = new LayerComposition(dimension);
        ImageLayer imageLayer = new ImageLayer(layerComposition, bufferedImage, Position.TOP);
        ImageLayer imageLayer2 = new ImageLayer(layerComposition, bufferedImage, Position.CENTER);
        ImageLayer imageLayer3 = new ImageLayer(layerComposition, bufferedImage, Position.BOTTOM);
        Dimension dimension2 = new Dimension(n * 2, n * 2);
        imageLayer.setImageFilter(convolveOp, dimension2);
        imageLayer2.setImageFilter(convolveOp2, dimension2);
        imageLayer3.setImageFilter(compositeOp, dimension2);
        layerComposition.setLayers(new Layer[]{imageLayer, imageLayer2, imageLayer3});
        CompositionComponent compositionComponent = new CompositionComponent(layerComposition);
        JFrame jFrame = new JFrame();
        jFrame.getContentPane().add(compositionComponent);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public static void mainDirect(String[] stringArray) {
        if (stringArray.length < 1) {
            System.out.println(USAGE);
            System.exit(0);
        }
        BufferedImage bufferedImage = Toolbox.loadImage(stringArray[0], 3);
        int n = 25;
        if (stringArray.length > 1) {
            n = Integer.parseInt(stringArray[1]);
        }
        System.out.println("Using radius : " + n);
        GaussianKernel gaussianKernel = new GaussianKernel(n);
        ConvolveOp convolveOp = new ConvolveOp(gaussianKernel);
        long l = System.currentTimeMillis();
        BufferedImage bufferedImage2 = convolveOp.filter(bufferedImage, null);
        System.out.println("Square convolution took: " + (System.currentTimeMillis() - l));
        Kernel[] kernelArray = gaussianKernel.separateKernel();
        convolveOp = new ConvolveOp(kernelArray[0]);
        l = System.currentTimeMillis();
        BufferedImage bufferedImage3 = convolveOp.filter(bufferedImage, null);
        System.out.println("Horizontal convolution took: " + (System.currentTimeMillis() - l));
        convolveOp = new ConvolveOp(kernelArray[1]);
        l = System.currentTimeMillis();
        BufferedImage bufferedImage4 = convolveOp.filter(bufferedImage3, null);
        System.out.println("Vertical convolution took: " + (System.currentTimeMillis() - l));
        Dimension dimension = new Dimension(bufferedImage.getWidth() * 2, bufferedImage.getHeight() * 2);
        LayerComposition layerComposition = new LayerComposition(dimension);
        layerComposition.setLayers(new Layer[]{new ImageLayer(layerComposition, bufferedImage, Position.BOTTOM_LEFT), new ImageLayer(layerComposition, bufferedImage2, Position.TOP_RIGHT), new ImageLayer(layerComposition, bufferedImage3, Position.BOTTOM_RIGHT), new ImageLayer(layerComposition, bufferedImage4, Position.TOP_LEFT)});
        CompositionComponent compositionComponent = new CompositionComponent(layerComposition);
        JFrame jFrame = new JFrame();
        jFrame.getContentPane().add(compositionComponent);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public static void traceKernel(float[] fArray) {
        int n = (int)Math.sqrt(fArray.length);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                int n2 = Math.round(fArray[i * n + j] * 10000.0f);
                GaussianKernel.trace(n2);
                System.out.print("  ");
            }
            System.out.println();
        }
        System.out.println();
    }

    public static void trace1DKernel(float[] fArray) {
        for (int i = 0; i < fArray.length; ++i) {
            int n = Math.round(fArray[i] * 10000.0f);
            GaussianKernel.trace(n);
            System.out.print("  ");
        }
        System.out.println();
    }

    public static void trace(int n) {
        if (n < 10) {
            System.out.print("0000");
        } else if (n < 100) {
            System.out.print("000");
        } else if (n < 1000) {
            System.out.print("00");
        } else if (n < 10000) {
            System.out.print("0");
        }
        System.out.print(n);
    }
}

