## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(echo = TRUE, cache = TRUE, autodep = TRUE)
set.seed(0xdada)

## ----exampledata, message=FALSE, warning=FALSE--------------------------------
data("featuresPerWell", package = "HD2013SGI")
str(featuresPerWell[[1]])
str(featuresPerWell[[2]])
stopifnot(nrow(featuresPerWell[[1]]) == nrow(featuresPerWell[[2]]))

## ----xl, results = "hide"-----------------------------------------------------
np = 40
nx = 24
ny = 16
plateNames = unique(featuresPerWell[[1]]$plate)
assertthat::assert_that(length(plateNames) >= np)
plateNames = plateNames[seq_len(np)]
xl = lapply(plateNames, function(pl) {
  sel = with(featuresPerWell[[1]], plate == pl & field == "1")
  rv = rep(NA_real_, nx * ny)
  r = match(featuresPerWell[[1]]$row[sel], LETTERS)
  c = match(featuresPerWell[[1]]$col[sel], paste(seq_len(nx)))
  i = (r-1) * nx + c
  assertthat::assert_that(!any(is.na(r)), !any(is.na(c)), !any(duplicated(i)),
                          all(r>=1), all(r<=ny), all(c>=1), all(c<=nx))
  rv[i] = featuresPerWell[[2]][sel, "count"]
  rv
})
names(xl) = plateNames

## ----fig1, fig.wide = TRUE, fig.cap = "Output of `splots::plotScreen`.", , fig.dim=c(10, 20)----
class(xl)
length(xl)
names(xl)[1:4]
unique(vapply(xl, function(x) paste(class(x), length(x)), character(1)))
xl[[1]][1:30]
splots::plotScreen(xl, nx = nx, ny = ny, ncol = 4, 
           fill = c("white", "darkgoldenrod4"), 
           main = "HD2013SGI", legend.label = "cell count",
           zrange = c(0, max(unlist(xl), na.rm = TRUE)))

## ----sessionInfo--------------------------------------------------------------
sessionInfo()

