shinyPanelPathway <- fluidPage(
  tags$div(
    class = "container",
    h1("Pathway Activity Analysis"),
    h5(tags$a(href = paste0(docs.artPath, "ui_gsva.html"),
              "(help)", target = "_blank")),
    sidebarLayout(
      sidebarPanel(
        uiOutput("pathwayAssay"),
        #selectInput("pathwayAssay", "Select Assay:", currassays),
        selectInput("pathwayMethod", "Select Method:", "GSVA"),
        uiOutput("selectPathwayGeneLists"),
        uiOutput("selectNumTopPaths"),
        selectInput("pathwayPlotVar",
                    "Select Condition(s) of interest for plot:", clusterChoice,
                    multiple = TRUE),
        radioButtons("pathwayOutPlot", "Plot Type:", c("Heatmap", "Violin")),
        withBusyIndicatorUI(actionButton("pathwayRun", "Run")),
        tags$hr(),
        h3("Save pathway results:"),
        actionButton("savePathway", "Save Pathways"),
        downloadButton("downloadPathway", "Download Pathway Results")
      ),
      mainPanel(
        tabsetPanel(
          tabPanel(
            "Plot",
            plotOutput("pathwayPlot", height = "600px")
          ),
          tabPanel(
            "Results Table",
            DT::dataTableOutput("pathwaytable")
          )
        )
      )
    )
  )
)

