## ----message=FALSE, warning=FALSE, include=FALSE------------------------------
library(sesame)
library(dplyr)
options(rmarkdown.html_vignette.check_title = FALSE)

## ---- eval=FALSE--------------------------------------------------------------
#  if (!requireNamespace("BiocManager", quietly=TRUE))
#      install.packages("BiocManager")
#  BiocManager::install("sesame")

## ---- eval=FALSE--------------------------------------------------------------
#  BiocManager::install('zwdzwd/sesameData')
#  BiocManager::install('zwdzwd/sesame')

## ----eval=FALSE---------------------------------------------------------------
#  sesameDataCacheAll()

## ----eval=FALSE---------------------------------------------------------------
#  sesameDataCache("EPIC")

## ----eval=FALSE---------------------------------------------------------------
#  sset = readIDAT("GSM2178224")
#  # or
#  sset = readIDAT("204529320035_R06C01")

## ----eval=FALSE---------------------------------------------------------------
#  sset = readIDAT("GSM2178224")
#  betas = getBetas(sset)

## -----------------------------------------------------------------------------
ssets = lapply(
    searchIDATprefixes(system.file("extdata/", package = "sesameData")),
    readIDATpair)

## -----------------------------------------------------------------------------
mft = sesameDataGet("MM285.address")$ordering

## -----------------------------------------------------------------------------
head(mft[!is.na(mft$col),])

## ----eval = FALSE-------------------------------------------------------------
#  sset = readIDATpair("your_sample_name", manifest = mft)
#  betas = getBetas(sset)

## -----------------------------------------------------------------------------
library(sesame)
## show case using an example without mask, then add mask with qualityMask
sset = qualityMask(sesameDataGet('EPIC.1.LNCaP')$sset)
betas = getBetas(sset, sum.TypeI = TRUE)

## -----------------------------------------------------------------------------
extraSNPAFs = getAFTypeIbySumAlleles(sset)

## ----message = FALSE----------------------------------------------------------
betas = getBetas(sset)
head(betas)

## -----------------------------------------------------------------------------
head(mask(sset))
sum(mask(sset))   # number of probes to be NA-masked
sum(is.na(betas)) # should be the same as above

## -----------------------------------------------------------------------------
sum(mask(sset))  # before resetting
sum(mask(resetMask(sset)))  # after resetting, expect 0

## -----------------------------------------------------------------------------
sum(is.na(getBetas(sset, mask=FALSE)))  # expect 0

## -----------------------------------------------------------------------------
sum(mask(sset))  # before pOOBAH
sum(mask(pOOBAH(sset))) # after pOOBAH, expect more probes
sum(mask(pOOBAH(resetMask(sset)))) # pOOBAH-only masking

## -----------------------------------------------------------------------------
pvals = pOOBAH(sset, return.pval=TRUE)
sset2 = addMask(sset, pvals > 0.05) # default, recommend between 0.05 and 0.2

## -----------------------------------------------------------------------------
sset.nb = noob(sset)          # noob background subtraction
sset.sb = scrub(sset)         # more aggressive background subtraction

## -----------------------------------------------------------------------------
sesamePlotIntensVsBetas(sset)
sesamePlotIntensVsBetas(sset.nb) # with noob
sesamePlotIntensVsBetas(sset.sb) # with scrub

## -----------------------------------------------------------------------------
library(sesame)
sset.dbLinear = dyeBiasCorr(sset)
sesamePlotRedGrnQQ(sset.dbLinear)

## -----------------------------------------------------------------------------
sset.dbNonlinear = dyeBiasCorrTypeINorm(sset)

## -----------------------------------------------------------------------------
sesamePlotRedGrnQQ(sset.dbNonlinear)

## -----------------------------------------------------------------------------
sset.InfICorrected = inferTypeIChannel(sset, verbose=TRUE)

## ----eval = FALSE-------------------------------------------------------------
#  idat_dir = system.file("extdata/", package = "sesameData")
#  betas = do.call(cbind, mclapply(searchIDATprefixes(idat_dir), function(pfx) {
#      getBetas(dyeBiasNL(noob(pOOBAH(readIDATpair(pfx)))))
#  }), mc.cores=2)

## ----eval = FALSE-------------------------------------------------------------
#  idat_dir = system.file("extdata/", package = "sesameData")
#  betas = openSesame(idat_dir, BPPARAM=BiocParallel::MulticoreParam(2))

## ----eval = FALSE-------------------------------------------------------------
#  betas = openSesame(idat_dir, manifest = manifest)

## -----------------------------------------------------------------------------
sset
head(II(sset)) # or sset@II
head(ctl(sset)) # the last column: the type of the control.

## ----message = FALSE----------------------------------------------------------
library(sesame)
library(FlowSorted.Blood.450k)
options(rmarkdown.html_vignette.check_title = FALSE)


## -----------------------------------------------------------------------------
grSet <- sesamize(FlowSorted.Blood.450k[,1:4])
grSet

