## ----style, echo=FALSE, results="asis", message=FALSE-------------------------
knitr::opts_chunk$set(tidy = FALSE,
		   message = FALSE)

## ----echo=FALSE, results="hide", message=FALSE--------------------------------
library("seqcombo")

## -----------------------------------------------------------------------------
fas <- list.files(system.file("examples","GVariation", package="seqcombo"),
                  pattern="fas", full.names=TRUE)
fas

## -----------------------------------------------------------------------------
x1 <- seqdiff(fas[1], reference=1)
x1

## ----fig.height=4, fig.width=12-----------------------------------------------
plot(x1)

## ----fig.height=12, fig.width=12----------------------------------------------
x <- lapply(fas, seqdiff)
plts <- lapply(x, plot)
plot_grid(plotlist=plts, ncol=1, labels=LETTERS[1:3])

## -----------------------------------------------------------------------------
fas <- system.file("examples/GVariation/sample_alignment.fa", package="seqcombo")
simplot(fas, 'CF_YL21')

## ----echo=FALSE---------------------------------------------------------------
sessionInfo()

