## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
    collapse = TRUE,
    comment = "#>"
)

## ----setup, eval=FALSE--------------------------------------------------------
#  library(igraph)
#  library(schex)
#  library(TENxPBMCData)
#  library(scater)
#  library(scran)
#  library(ggrepel)

## ----load, eval=FALSE---------------------------------------------------------
#  tenx_pbmc3k <- TENxPBMCData(dataset = "pbmc3k")
#  
#  rownames(tenx_pbmc3k) <- uniquifyFeatureNames(rowData(tenx_pbmc3k)$ENSEMBL_ID,
#      rowData(tenx_pbmc3k)$Symbol_TENx)

## ----filter-cells, eval=FALSE-------------------------------------------------
#  rowData(tenx_pbmc3k)$Mito <- grepl("^MT-", rownames(tenx_pbmc3k))
#  colData(tenx_pbmc3k) <- cbind(colData(tenx_pbmc3k),
#      perCellQCMetrics(tenx_pbmc3k,
#          subsets=list(Mt=rowData(tenx_pbmc3k)$Mito)))
#  rowData(tenx_pbmc3k) <- cbind(rowData(tenx_pbmc3k),
#      perFeatureQCMetrics(tenx_pbmc3k))
#  
#  tenx_pbmc3k <- tenx_pbmc3k[, !colData(tenx_pbmc3k)$subsets_Mt_percent > 50]
#  
#  libsize_drop <- isOutlier(tenx_pbmc3k$total,
#        nmads = 3,type = "lower", log = TRUE)
#  feature_drop <- isOutlier(tenx_pbmc3k$detected,
#      nmads = 3, type = "lower", log = TRUE)
#  
#  tenx_pbmc3k <- tenx_pbmc3k[, !(libsize_drop | feature_drop)]

## ----filter-genes, eval=FALSE-------------------------------------------------
#  rm_ind <- calculateAverage(tenx_pbmc3k)<0
#  tenx_pbmc3k <- tenx_pbmc3k[!rm_ind,]

## ----norm, message=FALSE, warning=FALSE, eval=FALSE---------------------------
#  tenx_pbmc3k <- scater::logNormCounts(tenx_pbmc3k)

## ----dim-red, message=FALSE, warning=FALSE, eval=FALSE------------------------
#  tenx_pbmc3k <- runPCA(tenx_pbmc3k)
#  set.seed(10)
#  tenx_pbmc3k <- runUMAP(tenx_pbmc3k, dimred = "PCA", spread = 1,
#      min_dist = 0.4)

## ----cluster, eval=FALSE------------------------------------------------------
#  snn_gr <- buildSNNGraph(tenx_pbmc3k, use.dimred = "PCA", k = 50)
#  clusters <- cluster_louvain(snn_gr)
#  tenx_pbmc3k$cluster <- factor(clusters$membership)

## ---- eval=FALSE--------------------------------------------------------------
#  plot_hexbin_density_shiny(tenx_pbmc3k, 10, 50, dimension_reduction = "UMAP")

## ---- eval=FALSE--------------------------------------------------------------
#  plot_hexbin_feature_shiny(tenx_pbmc3k, type="counts", feature="POMGNT1",
#      action="prop_0", min_nbins=10, max_nbins=50, dimension_reduction="UMAP",
#      mod="RNA")

## ---- eval=FALSE--------------------------------------------------------------
#  plot_hexbin_meta_shiny(tenx_pbmc3k, col="cluster",
#      action="majority", min_nbins=10, max_nbins=50, dimension_reduction="UMAP")

