/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.gff;

import org.biojava.bio.program.gff.GFFRecord;

public interface GFFRecordFilter {
    public static final GFFRecordFilter ACCEPT_ALL = new AcceptAll();

    public boolean accept(GFFRecord var1);

    public static class AcceptAll
    implements GFFRecordFilter {
        public boolean accept(GFFRecord gFFRecord) {
            return true;
        }
    }

    public static class SequenceFilter
    implements GFFRecordFilter {
        private String seqName;

        public boolean accept(GFFRecord gFFRecord) {
            return gFFRecord.getSeqName().equals(this.seqName);
        }

        public String getSeqName() {
            return this.seqName;
        }

        public void setSeqName(String string) {
            this.seqName = string;
        }
    }

    public static class SourceFilter
    implements GFFRecordFilter {
        private String source;

        public boolean accept(GFFRecord gFFRecord) {
            return gFFRecord.getSource().equals(this.source);
        }

        public String getSource() {
            return this.source;
        }

        public void setSource(String string) {
            this.source = string;
        }
    }

    public static class FeatureFilter
    implements GFFRecordFilter {
        private String feature;

        public boolean accept(GFFRecord gFFRecord) {
            return gFFRecord.getFeature().equals(this.feature);
        }

        public String getFeature() {
            return this.feature;
        }

        public void setFeature(String string) {
            this.feature = string;
        }
    }
}

