### R code from vignette source 'bgx.Rnw'

###################################################
### code chunk number 1: bgx.Rnw:35-36
###################################################
library(bgx)


###################################################
### code chunk number 2: bgx.Rnw:61-65
###################################################
library(affydata)
library(hgu95av2cdf)
data(Dilution)
eset <- bgx(Dilution, samplesets=c(2,2), probeAff=FALSE, burnin=2048, iter=8192,genes=c(12500:12599), output="all")


###################################################
### code chunk number 3: bgx.Rnw:70-71
###################################################
exprs(eset)[10:40,] # Shorthand for assayData(eset)\$exprs[10:40,]


###################################################
### code chunk number 4: bgx.Rnw:78-79
###################################################
sampleNames(Dilution)


###################################################
### code chunk number 5: bgx.Rnw:102-103
###################################################
bgxOutput <- readOutput.bgx("run.1")


###################################################
### code chunk number 6: bgx.Rnw:108-109
###################################################
plotExpressionDensity(bgxOutput, gene=10)


###################################################
### code chunk number 7: bgx.Rnw:114-116
###################################################
rankedGeneList <- rankByDE(bgxOutput)
print(rankedGeneList[1:25,]) # print top 25 DEG


###################################################
### code chunk number 8: bgx.Rnw:121-122
###################################################
unlink("run.1", recursive=TRUE)


