## ---- eval = FALSE------------------------------------------------------------
#  if (!requireNamespace("BiocManager",
#                        quietly = TRUE)) {
#    install.packages("BiocManager")
#  }
#  BiocManager::install("SynExtend")

## ---- build_synteny_object----------------------------------------------------
library(SynExtend)

DBPATH <- system.file("extdata",
                      "VignetteSeqs.sqlite",
                      package = "SynExtend")

Syn <- FindSynteny(dbFile = DBPATH)

## ---- synplots01--------------------------------------------------------------
Syn
pairs(Syn)

## ---- synplots02--------------------------------------------------------------
print(head(Syn[[1, 2]]))
print(head(Syn[[2, 1]]))

## ---- generate_genecalls------------------------------------------------------
GeneCalls <- vector(mode = "list",
                    length = ncol(Syn))

GeneCalls[[1L]] <- gffToDataFrame(GFF = system.file("extdata",
                                                    "GCA_006740685.1_ASM674068v1_genomic.gff.gz",
                                                    package = "SynExtend"),
                                  Verbose = TRUE)
GeneCalls[[2L]] <- gffToDataFrame(GFF = system.file("extdata",
                                                    "GCA_000956175.1_ASM95617v1_genomic.gff.gz",
                                                    package = "SynExtend"),
                                  Verbose = TRUE)
GeneCalls[[3L]] <- gffToDataFrame(GFF = system.file("extdata",
                                                    "GCA_000875775.1_ASM87577v1_genomic.gff.gz",
                                                    package = "SynExtend"),
                                  Verbose = TRUE)

names(GeneCalls) <- seq(length(GeneCalls))

## ---- print_gene_calls--------------------------------------------------------
print(head(GeneCalls[[1]]))

## ---- show_rtracklayer, eval = FALSE------------------------------------------
#  X01 <- rtracklayer::import(system.file("extdata",
#                                         "GCA_000875775.1_ASM87577v1_genomic.gff.gz",
#                                         package = "SynExtend"))
#  class(X01)
#  print(X01)

## ---- generate_initial_links--------------------------------------------------
Links <- NucleotideOverlap(SyntenyObject = Syn,
                           GeneCalls = GeneCalls,
                           LimitIndex = FALSE,
                           Verbose = TRUE)

## ---- link_printing-----------------------------------------------------------
class(Links)
print(Links)

## ---- describe_links----------------------------------------------------------
LinkedPairs1 <- PairSummaries(SyntenyLinks = Links,
                              DBPATH = DBPATH,
                              PIDs = FALSE,
                              Verbose = TRUE)

## ---- describe_more_links_again-----------------------------------------------
print(head(LinkedPairs1))

## ---- pairsummariesoperations-------------------------------------------------
SingleLinkageClusters <- DisjointSet(Pairs = LinkedPairs1,
                                     Verbose = TRUE)

## ---- clusters----------------------------------------------------------------
SeqsByCluster <- ExtractBy(x = LinkedPairs1,
                           y = SingleLinkageClusters,
                           Method = "clusters",
                           DBPATH = DBPATH,
                           Verbose = TRUE)

head(SeqsByCluster)

## -----------------------------------------------------------------------------
sessionInfo()

