## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(dpi = 300)
knitr::opts_chunk$set(cache=FALSE)

## ---- eval = TRUE, echo = FALSE,hide=TRUE, message=FALSE,warning=FALSE--------
devtools::load_all()

## ---- eval = FALSE------------------------------------------------------------
#  if (!requireNamespace("BiocManager", quietly=TRUE))
#      install.packages("BiocManager")
#  BiocManager::install("SpidermiR")

## ---- eval = TRUE-------------------------------------------------------------

org<-SpidermiRquery_species(species)

## ---- eval = TRUE, echo = FALSE-----------------------------------------------
knitr::kable(org, digits = 2,
             caption = "List of species",row.names = TRUE)

## ---- eval = TRUE-------------------------------------------------------------
net_type<-SpidermiRquery_networks_type(organismID=org[9,])

## ---- eval = TRUE, echo = FALSE-----------------------------------------------
net_type

## ---- eval = TRUE-------------------------------------------------------------

net_shar_prot<-SpidermiRquery_spec_networks(organismID = org[9,],
                                    network = "SHpd")

## ---- eval = TRUE, echo = FALSE-----------------------------------------------
net_shar_prot

## ---- eval = TRUE-------------------------------------------------------------
out_net<-SpidermiRdownload_net(net_shar_prot)

## ---- eval = TRUE, echo = FALSE-----------------------------------------------
str(out_net)

## ---- eval = FALSE------------------------------------------------------------
#  mirna<-c('hsa-miR-567','hsa-miR-566')
#  SpidermiRdownload_miRNAprediction(mirna_list=mirna)

## ---- eval = FALSE------------------------------------------------------------
#  list<-SpidermiRdownload_miRNAvalidate(validated)

## ---- eval = FALSE------------------------------------------------------------
#  list_circ<-SpidermiRdownload_miRNAextra_cir(miRNAextra_cir)

## ---- eval = TRUE-------------------------------------------------------------

geneSymb_net<-SpidermiRprepare_NET(organismID = org[9,],
                                    data = out_net)

## ---- eval = TRUE, echo = FALSE-----------------------------------------------
knitr::kable(geneSymb_net[[1]][1:5,c(1,2,3,5,8)], digits = 2,
             caption = "shared protein domain",row.names = FALSE)

## ---- eval = TRUE-------------------------------------------------------------
biomark_of_interest<-c("hsa-let-7a","CDC34","hsa-miR-27a","PEX7","EPT1","FOX","hsa-miR-5a")
miRNA_NET <-data.frame(V1=c('hsa-let-7a','CASP3','BRCA','hsa-miR-7a','hsa-miR-5a','SMAD','SOX'),V2=c('CASP3','TAMOXIFEN','MYC','PTEN','FOX','HIF1','P53'),stringsAsFactors=FALSE)
GIdirect_net<-SpidermiRanalyze_direct_net(data=miRNA_NET,BI=biomark_of_interest)

## ---- eval = TRUE, echo = FALSE-----------------------------------------------
str(GIdirect_net)

## ---- eval = FALSE------------------------------------------------------------
#  
#  subnet<-SpidermiRanalyze_direct_subnetwork(data=miRNA_NET,BI=biomark_of_interest)
#  

## ---- eval = FALSE------------------------------------------------------------
#  
#  GIdirect_net_neigh<-SpidermiRanalyze_subnetwork_neigh(data=miRNA_NET,BI=biomark_of_interest)

## ---- eval = FALSE------------------------------------------------------------
#  top10_cent_gene<-SpidermiRanalyze_degree_centrality(miRNA_NET)

## ---- eval = TRUE,echo = FALSE------------------------------------------------
B<-matrix( c("Gene network", "Validated miRNA-target","", "Predicted miRNA-target","","","", "Extracellular Circulating microRNAs", "Pharmaco-miR","",
      
             "GeneMania", "miRwalk","miRTarBase", "DIANA", "Miranda", "PicTar","TargetScan","miRandola","DGIdb","MATADOR",
             
             "Current","miRwalk2","miRTarBase 7","DIANA- 5.0","N/A","N/A","TargetScan7.1","miRandola v 02/2017","N/A","N/A",
             2017,2015,2017,2013,2010,"N/A","2016",2017,2018,"N/A",
             "http://genemania.org/data/current/","http://zmf.umm.uni-heidelberg.de/apps/zmf/mirwalk2/downloads/vtm/hsa-vtm-gene.rdata.zip","http://mirtarbase.mbc.nctu.edu.tw/cache/download/7.0/miRTarBase_SE_WR.xls","https://bioconductor.org/packages/release/bioc/html/miRNAtap.html","https://bioconductor.org/packages/release/bioc/html/miRNAtap.html","https://bioconductor.org/packages/release/bioc/html/miRNAtap.html","https://bioconductor.org/packages/release/bioc/html/miRNAtap.html","http://mirandola.iit.cnr.it/download/miRandola_version_02_2017.txt","http://dgidb.org/data/interactions.tsv", "http://matador.embl.de/media/download/matador.tsv.gz"
             
             ), nrow=10, ncol=5)
colnames(B)<-c("CATEGORY","EXTERNAL DATABASE","VERSION","LAST UPDATE","LINK")


## ---- eval = TRUE, echo = FALSE-----------------------------------------------
knitr::kable(B, digits = 2,
             caption = "Features",row.names = FALSE)

## ----sessionInfo--------------------------------------------------------------
sessionInfo()

