/*
 * Decompiled with CFR 0.152.
 */
package reder.application.graph;

import java.awt.Color;
import java.util.Hashtable;
import java.util.regex.Pattern;
import reder.application.MainFrame;
import reder.application.graph.NodeBank;

public class EdgeBank {
    protected int parceiroA;
    protected int parceiroB;
    protected Hashtable timeVector;
    private Color edgeColor;
    private float lineWidth;
    private String shapeType;
    private final Color corDestaque;
    protected boolean destaque;
    private double edgeWeight;
    private double normalizedWeight;
    private double normOutEdgeScale;
    private final boolean isToHide;
    private boolean defaultEdgeAssigment;
    private boolean isOutEdge;
    private boolean isOldEdge;
    private int arrow;
    private int units;
    private float ARROW_RELATIVE_LENGTH;
    private float OPENING_ANGLE;
    private final int edgeID;

    public EdgeBank(int parceiroA, int parceiroB, int edgeID) {
        this.edgeID = edgeID;
        this.parceiroA = parceiroA;
        this.parceiroB = parceiroB;
        this.edgeColor = new Color(153, 153, 255);
        this.lineWidth = 1.0f;
        this.shapeType = "SOLID";
        this.corDestaque = new Color(255, 204, 0);
        this.destaque = false;
        this.edgeWeight = 0.0;
        this.units = 1;
        this.normalizedWeight = 0.0;
        this.normOutEdgeScale = 1.0;
        this.arrow = 0;
        this.timeVector = new Hashtable();
        this.isToHide = false;
        this.defaultEdgeAssigment = true;
        this.isOutEdge = false;
        this.isOldEdge = true;
        this.ARROW_RELATIVE_LENGTH = 5.0f;
        this.OPENING_ANGLE = 20.0f;
    }

    public float getArrowLength() {
        return this.ARROW_RELATIVE_LENGTH;
    }

    public void setArrowLength(float len) {
        this.ARROW_RELATIVE_LENGTH = len = Math.max(0.0f, len);
    }

    public void setArrowLengthScale(float len) {
        this.ARROW_RELATIVE_LENGTH *= len;
        this.ARROW_RELATIVE_LENGTH = Math.max(0.0f, this.ARROW_RELATIVE_LENGTH);
    }

    public float getArrowAngle() {
        return this.OPENING_ANGLE;
    }

    public void setArrowAngle(float angl) {
        this.OPENING_ANGLE = angl = Math.max(0.0f, Math.min(90.0f, angl));
    }

    public void setArrowAngleScale(float angl) {
        this.OPENING_ANGLE *= angl;
        this.OPENING_ANGLE = Math.max(0.0f, Math.min(90.0f, this.OPENING_ANGLE));
    }

    public int getFinalID() {
        return this.edgeID;
    }

    public void resetNodes(int node) {
        if (this.parceiroA > node) {
            --this.parceiroA;
        }
        if (this.parceiroB > node) {
            --this.parceiroB;
        }
    }

    public void setEdgeWeight(double edgeWeight) {
        this.edgeWeight = edgeWeight;
    }

    public void setWeight(double edgeWeight) {
        this.edgeWeight = edgeWeight;
    }

    public double getMeanWeight() {
        double wmean = this.edgeWeight / (double)this.units;
        return wmean;
    }

    public double getWeight() {
        return this.edgeWeight;
    }

    public void setNormWeight(double weight) {
        this.normalizedWeight = weight;
    }

    public double getNormWeight() {
        return this.normalizedWeight;
    }

    public void addUnit(int u) {
        this.units += u;
    }

    public int getUnit() {
        return this.units;
    }

    public void setOutEdge(boolean b) {
        this.isOutEdge = b;
    }

    public boolean isOutEdge() {
        return this.isOutEdge;
    }

    public int normOutEdgeScale() {
        if (!this.defaultEdgeAssigment) {
            NodeBank na = MainFrame.NodeList.get(this.parceiroA);
            NodeBank nb = MainFrame.NodeList.get(this.parceiroB);
            double sa = 1.0;
            double sb = 1.0;
            if (na.isContainer()) {
                sa = na.getContainerComponents().size();
            }
            if (nb.isContainer()) {
                sb = nb.getContainerComponents().size();
            }
            if (sa > 0.0 && sb > 0.0) {
                this.normOutEdgeScale = (double)this.units / (sa * sb);
                return 1;
            }
        }
        return 0;
    }

    public void setNormOutEdgeScale(double nvalue) {
        this.normOutEdgeScale = nvalue;
    }

    public double getNormOutEdge() {
        return this.normOutEdgeScale;
    }

    public void setOltEdge(boolean b) {
        this.isOldEdge = b;
    }

    public boolean isOldEdge() {
        return this.isOldEdge;
    }

    public void attToEdgeWidth(float target, float range) {
        float base = (1.0f - (range /= 100.0f)) * target;
        float projectAtt = (float)((double)base + (double)(target -= base) * Math.abs(this.normalizedWeight));
        this.setLineWidth(projectAtt);
    }

    public void attToEdgeColor(Color target) {
        int r = (int)((double)target.getRed() + (204.0 - 204.0 * this.normalizedWeight));
        int g = (int)((double)target.getGreen() + (204.0 - 204.0 * this.normalizedWeight));
        int b = (int)((double)target.getBlue() + (204.0 - 204.0 * this.normalizedWeight));
        r = Math.min(r, 204);
        g = Math.min(g, 204);
        b = Math.min(b, 204);
        this.edgeColor = new Color(r, g, b);
    }

    public void attToGradientColor(Color source, Color target) {
        Color sourceColor = source;
        Color targeColor = target;
        int sr = sourceColor.getRed();
        int sg = sourceColor.getGreen();
        int sb = sourceColor.getBlue();
        int tr = targeColor.getRed();
        int tg = targeColor.getGreen();
        int tb = targeColor.getBlue();
        int r = sr;
        int g = sg;
        int b = sb;
        if (sr < tr) {
            r = (int)((double)sr + (double)(tr - sr) * this.normalizedWeight);
            r = Math.min(r, tr);
        } else if (sr > tr) {
            r = (int)((double)sr - (double)(sr - tr) * this.normalizedWeight);
            r = Math.max(r, tr);
        }
        if (sg < tg) {
            g = (int)((double)sg + (double)(tg - sg) * this.normalizedWeight);
            g = Math.min(g, tg);
        } else if (sg > tg) {
            g = (int)((double)sg - (double)(sg - tg) * this.normalizedWeight);
            g = Math.max(g, tg);
        }
        if (sb < tb) {
            b = (int)((double)sb + (double)(tb - sb) * this.normalizedWeight);
            b = Math.min(b, tb);
        } else if (sb > tb) {
            b = (int)((double)sb - (double)(sb - tb) * this.normalizedWeight);
            b = Math.max(b, tb);
        }
        this.edgeColor = new Color(r, g, b);
    }

    public void setDefaultContainerEdge(boolean b) {
        this.defaultEdgeAssigment = b;
    }

    public boolean isDefaultEdgeAssignmet() {
        return this.defaultEdgeAssigment;
    }

    public String getEdgeAssociationType() {
        if (this.isAorBContainer()) {
            if (!this.defaultEdgeAssigment) {
                return "edgeContainer";
            }
            return "edgeTree";
        }
        return "edgeNode";
    }

    public boolean isAorBContainer() {
        boolean c1 = MainFrame.NodeList.get(this.parceiroA).isContainer();
        boolean c2 = MainFrame.NodeList.get(this.parceiroB).isContainer();
        return c1 || c2;
    }

    public void updateDefaultEdgeAssigment() {
        if (!this.isAorBContainer()) {
            this.defaultEdgeAssigment = true;
        }
    }

    public boolean isToHideEdge() {
        return this.isToHide;
    }

    public void setA(int numero) {
        this.parceiroA = numero;
    }

    public void setB(int numero) {
        this.parceiroB = numero;
    }

    public void setDestaque(boolean destaque) {
        this.destaque = destaque;
    }

    public void setDestaqueInNest(String nest) {
        boolean b3;
        NodeBank na = MainFrame.NodeList.get(this.parceiroA);
        NodeBank nb = MainFrame.NodeList.get(this.parceiroB);
        boolean b1 = na.getNestedAssignment().equals(nest);
        boolean b2 = nb.getNestedAssignment().equals(nest);
        boolean bl = b3 = !na.isContainer() && !nb.isContainer();
        if (b1 && b2 && b3) {
            this.destaque = true;
        }
    }

    public void setDestaque() {
        this.destaque = !this.destaque;
    }

    public void setColor(Color edgeColor) {
        this.edgeColor = edgeColor;
    }

    public void setLine(float size, String type) {
        this.lineWidth = size;
        this.shapeType = type;
    }

    public void setLine(float size) {
        this.lineWidth = size;
    }

    public void setLine(String type) {
        boolean b = Pattern.matches("SOLID|DOTTED_SHORT|LONG_DASH|DOTTED", type);
        if (b) {
            this.shapeType = type;
        }
    }

    public void setLineWidth(float width) {
        if (width < 0.0f) {
            return;
        }
        this.lineWidth = width;
    }

    public void setEdgeSizeScale(float width) {
        this.lineWidth *= width;
    }

    public void setArrowDirection(int direction) {
        if (direction < -4 || direction > 4) {
            return;
        }
        this.arrow = direction;
    }

    public int getArrowDirection() {
        if (this.getEdgeAssociationType().equals("edgeTree")) {
            return 0;
        }
        return this.arrow;
    }

    public int getA() {
        return this.parceiroA;
    }

    public int getB() {
        return this.parceiroB;
    }

    public Color getColor() {
        Color cor = this.destaque ? this.corDestaque : this.edgeColor;
        return cor;
    }

    public Color getEdgeColor() {
        return this.edgeColor;
    }

    public float getWidth() {
        return this.lineWidth;
    }

    public String getType() {
        return this.shapeType;
    }

    public boolean getDestaque() {
        return this.destaque;
    }
}

