/*
 * Decompiled with CFR 0.152.
 */
package reder.application.cluster;

import reder.application.cluster.Cluster;

class Centroid {
    private double mCx;
    private double mCy;
    private Cluster mCluster;

    public Centroid(double cx, double cy) {
        this.mCx = cx;
        this.mCy = cy;
    }

    public void calcCentroid() {
        int i;
        int numDP = this.mCluster.getNumDataPoints();
        double tempX = 0.0;
        double tempY = 0.0;
        for (i = 0; i < numDP; ++i) {
            tempX += this.mCluster.getDataPoint(i).getX();
            tempY += this.mCluster.getDataPoint(i).getY();
        }
        this.mCx = tempX / (double)numDP;
        this.mCy = tempY / (double)numDP;
        for (i = 0; i < numDP; ++i) {
            this.mCluster.getDataPoint(i).calcEuclideanDistance();
        }
        this.mCluster.calcSumOfSquares();
    }

    public void setCluster(Cluster c) {
        this.mCluster = c;
    }

    public double getCx() {
        return this.mCx;
    }

    public double getCy() {
        return this.mCy;
    }

    public Cluster getCluster() {
        return this.mCluster;
    }
}

