## ----style, echo=FALSE, results='asis', message=FALSE-------------------------
BiocStyle::markdown()
knitr::opts_chunk$set(tidy         = FALSE,
                      message      = FALSE)


## ----setup--------------------------------------------------------------------
library(MungeSumstats)

## ---- message=TRUE------------------------------------------------------------
eduAttainOkbayPth <- system.file("extdata","eduAttainOkbay.txt",
                                  package="MungeSumstats")
reformatted <- 
  MungeSumstats::format_sumstats(path=eduAttainOkbayPth,ref_genome="GRCh37")

## ---- message=TRUE------------------------------------------------------------
#save ALS GWAS from the ieu open GWAS project to a temp directory
ALSvcfPth <- system.file("extdata","ALSvcf.vcf",package="MungeSumstats")
#set a low INFO filter so we get a return
reformatted_vcf <- 
  MungeSumstats::format_sumstats(path=ALSvcfPth, ref_genome="GRCh37",INFO_filter=0.1)

## ---- message=TRUE, echo=FALSE------------------------------------------------
sessionInfo()

