## ----style, echo = FALSE, results = 'asis', message=FALSE---------------------
BiocStyle::markdown()

## ---- echo = FALSE, message = FALSE-------------------------------------------
library(Spectra)
library(BiocStyle)

## ---- eval = FALSE------------------------------------------------------------
#  if (!requireNamespace("BiocManager", quietly = TRUE))
#      install.packages("BiocManager")
#  
#  BiocManager::install("MsBackendMgf")

## ----load-libs----------------------------------------------------------------
library(Spectra)
library(MsBackendMgf)

fls <- dir(system.file("extdata", package = "MsBackendMgf"),
           full.names = TRUE, pattern = "mgf$")
fls

## ----import-------------------------------------------------------------------
library(BiocParallel)
register(SerialParam())

sps <- Spectra(fls, source = MsBackendMgf())

## ----spectravars--------------------------------------------------------------
spectraVariables(sps)

## ----instrument---------------------------------------------------------------
sps$rtime
sps$TITLE

## ----spectravariables---------------------------------------------------------
spectraVariableMapping()

## ----map----------------------------------------------------------------------
map <- c(spectrumName = "TITLE", spectraVariableMapping())
map

## ----import2------------------------------------------------------------------
sps <- Spectra(fls, source = MsBackendMgf(), mapping = map)

## ----spectrumName-------------------------------------------------------------
sps$spectrumName

## ----mz-----------------------------------------------------------------------
mz(sps)
intensity(sps)

## ----export-------------------------------------------------------------------
fl <- tempfile()
export(sps, backend = MsBackendMgf(), file = fl, mapping = map)

## ----export-check-------------------------------------------------------------
readLines(fl)[1:12]

## -----------------------------------------------------------------------------
sps$new_variable <- "A"
export(sps, backend = MsBackendMgf(), file = fl)
readLines(fl)[1:12]

## -----------------------------------------------------------------------------
sessionInfo()

