## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
    comment = "#>",
    error = FALSE,
    warning = FALSE,
    message = FALSE,
    crop = NULL
)

## ---- echo=FALSE, out.width='50%', fig.align='center'-------------------------
knitr::include_graphics(path = system.file("app", "www", "logo.png", 
                                           package="InterCellar", mustWork=TRUE))

## ----eval = FALSE-------------------------------------------------------------
#  if (!requireNamespace("BiocManager", quietly = TRUE))
#      install.packages("BiocManager")
#  
#  BiocManager::install("InterCellar")

## ----setup--------------------------------------------------------------------
library(InterCellar)

## ----demostart, eval=FALSE----------------------------------------------------
#  InterCellar::run_app( reproducible = TRUE )

## ---- echo=FALSE, out.width='100%', fig.align='center'------------------------
knitr::include_graphics(path = system.file("app", "www", "About_shiny.png", 
                                           package="InterCellar", mustWork=TRUE))

## ---- echo=FALSE, out.width='120%',fig.align='center'-------------------------
knitr::include_graphics(path = "screenshots/upload_cpdb.png")

## ---- echo=FALSE, fig.align='center'------------------------------------------
knitr::include_graphics(path = "screenshots/table_view.png")

## ---- echo=FALSE, fig.align='center'------------------------------------------
knitr::include_graphics(path = "screenshots/cl_verse_net.png")

## ---- echo=FALSE, fig.align='center'------------------------------------------
knitr::include_graphics(path = "screenshots/cl_verse_bar.png")

## ---- echo=FALSE, fig.align='center'------------------------------------------
knitr::include_graphics(path = "screenshots/cl_verse_table.png")

## ---- echo=FALSE, fig.align='center'------------------------------------------
knitr::include_graphics(path = "screenshots/g_verse_table.png")

## ---- echo=FALSE, fig.align='center'------------------------------------------
knitr::include_graphics(path = "screenshots/g_verse_dot.png")

## ---- echo=FALSE, fig.align='center'------------------------------------------
knitr::include_graphics(path = "screenshots/f_verse_tab.png")

## ---- echo=FALSE, fig.align='center'------------------------------------------
knitr::include_graphics(path = "screenshots/f_verse_ranking.png")

## ---- echo=FALSE, fig.align='center'------------------------------------------
knitr::include_graphics(path = "screenshots/f_verse_sunburst.png")

## ---- echo=FALSE, fig.align='center'------------------------------------------
knitr::include_graphics(path = "screenshots/ipM_analysis.png")

## ---- echo=FALSE, fig.align='center'------------------------------------------
knitr::include_graphics(path = "screenshots/ipM_def.png")

## ---- echo=FALSE, fig.align='center'------------------------------------------
knitr::include_graphics(path = "screenshots/ipM_circle.png")

## ---- echo=FALSE, fig.align='center'------------------------------------------
knitr::include_graphics(path = "screenshots/ipM_function.png")

