## ----setup, include = FALSE-------------------------------------------------------------------------------------------
knitr::opts_chunk$set(
    collapse = TRUE,
    comment = "#>",
    crop = NULL 
    ## Related to 
    ## https://stat.ethz.ch/pipermail/bioc-devel/2020-April/016656.html
)

## ----vignetteSetup, echo=FALSE, message=FALSE, warning = FALSE--------------------------------------------------------
## Track time spent on making the vignette
startTime <- Sys.time()

## Bib setup
library("knitcitations")

## Load knitcitations with a clean bibliography
cleanbib()
cite_options(hyperlink = "to.doc", citation_format = "text", style = "html")

## Write bibliography information
bib <- c(
    R = citation(),
    BiocStyle = citation("BiocStyle")[1],
    knitcitations = citation("knitcitations")[1],
    knitr = citation("knitr")[1],
    rmarkdown = citation("rmarkdown")[1],
    sessioninfo = citation("sessioninfo")[1],
    testthat = citation("testthat")[1],
    ISAnalytics = citation("ISAnalytics")[1]
)

write.bibtex(bib, file = "no_rstudio_usage.bib")

## ----installBioc, eval=FALSE------------------------------------------------------------------------------------------
#  ## For release version
#  if(!requireNamespace("BiocManager", quietly = TRUE))
#      install.packages("BiocManager")
#  BiocManager::install("ISAnalytics")
#  
#  ## For devel version
#  if(!requireNamespace("BiocManager", quietly = TRUE))
#      install.packages("BiocManager")
#  # The following initializes usage of Bioc devel
#  BiocManager::install(version='devel')
#  BiocManager::install("ISAnalytics")

## ----installGitHub, eval=FALSE----------------------------------------------------------------------------------------
#  # For release version
#  if (!require(devtools)) {
#    install.packages("devtools")
#  }
#  devtools::install_github("calabrialab/ISAnalytics",
#                           ref = "RELEASE_3_12",
#                           dependencies = TRUE,
#                           build_vignettes = TRUE)
#  
#  ## Safer option for vignette building issue
#  devtools::install_github("calabrialab/ISAnalytics",
#                           ref = "RELEASE_3_12")
#  
#  # For devel version
#  if (!require(devtools)) {
#    install.packages("devtools")
#  }
#  devtools::install_github("calabrialab/ISAnalytics",
#                           ref = "master",
#                           dependencies = TRUE,
#                           build_vignettes = TRUE)
#  
#  ## Safer option for vignette building issue
#  devtools::install_github("calabrialab/ISAnalytics",
#                           ref = "master")

## ---------------------------------------------------------------------------------------------------------------------
library(ISAnalytics)

## ----OptVerbose, eval=FALSE-------------------------------------------------------------------------------------------
#  # DISABLE
#  options("ISAnalytics.verbose" = FALSE)
#  
#  # ENABLE
#  options("ISAnalytics.verbose" = TRUE)
#  

## ----OptWidg, eval=FALSE----------------------------------------------------------------------------------------------
#  # DISABLE HTML REPORTS
#  options("ISAnalytics.widgets" = FALSE)
#  
#  # ENABLE HTML REPORTS
#  options("ISAnalytics.widgets" = TRUE)

## ----eval=FALSE-------------------------------------------------------------------------------------------------------
#  options(browser = "firefox")

## ----eval=FALSE-------------------------------------------------------------------------------------------------------
#  options(browser = "firefox")
#  library(ISAnalytics)

## ----reproduce3, echo=FALSE-------------------------------------------------------------------------------------------
## Session info
library("sessioninfo")
options(width = 120)
session_info()

## ----vignetteBiblio, results = "asis", echo = FALSE, warning = FALSE, message = FALSE---------------------------------
## Print bibliography
bibliography()

